<?php

namespace EnumType;

/**
 * This class stands for position_code_enum EnumType
 * @subpackage Enumerations
 */
class Position_code_enum
{
    /**
     * Constant for value 'AL'
     * @return string 'AL'
     */
    const VALUE_AL = 'AL';
    /**
     * Constant for value 'LE'
     * @return string 'LE'
     */
    const VALUE_LE = 'LE';
    /**
     * Constant for value 'MI'
     * @return string 'MI'
     */
    const VALUE_MI = 'MI';
    /**
     * Constant for value 'RI'
     * @return string 'RI'
     */
    const VALUE_RI = 'RI';
    /**
     * Constant for value 'LB'
     * @return string 'LB'
     */
    const VALUE_LB = 'LB';
    /**
     * Constant for value 'RB'
     * @return string 'RB'
     */
    const VALUE_RB = 'RB';
    /**
     * Constant for value 'N'
     * @return string 'N'
     */
    const VALUE_N = 'N';
    /**
     * Constant for value 'NE'
     * @return string 'NE'
     */
    const VALUE_NE = 'NE';
    /**
     * Constant for value 'E'
     * @return string 'E'
     */
    const VALUE_E = 'E';
    /**
     * Constant for value 'SE'
     * @return string 'SE'
     */
    const VALUE_SE = 'SE';
    /**
     * Constant for value 'S'
     * @return string 'S'
     */
    const VALUE_S = 'S';
    /**
     * Constant for value 'SW'
     * @return string 'SW'
     */
    const VALUE_SW = 'SW';
    /**
     * Constant for value 'W'
     * @return string 'W'
     */
    const VALUE_W = 'W';
    /**
     * Constant for value 'NW'
     * @return string 'NW'
     */
    const VALUE_NW = 'NW';
    /**
     * Constant for value 'BI'
     * @return string 'BI'
     */
    const VALUE_BI = 'BI';
    /**
     * Constant for value 'SM'
     * @return string 'SM'
     */
    const VALUE_SM = 'SM';
    /**
     * Constant for value 'OL'
     * @return string 'OL'
     */
    const VALUE_OL = 'OL';
    /**
     * Constant for value 'EW'
     * @return string 'EW'
     */
    const VALUE_EW = 'EW';
    /**
     * Constant for value 'MP'
     * @return string 'MP'
     */
    const VALUE_MP = 'MP';
    /**
     * Constant for value 'FP'
     * @return string 'FP'
     */
    const VALUE_FP = 'FP';
    /**
     * Constant for value 'VA'
     * @return string 'VA'
     */
    const VALUE_VA = 'VA';
    /**
     * Constant for value 'RY'
     * @return string 'RY'
     */
    const VALUE_RY = 'RY';
    /**
     * Constant for value 'GY'
     * @return string 'GY'
     */
    const VALUE_GY = 'GY';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_AL
     * @uses self::VALUE_LE
     * @uses self::VALUE_MI
     * @uses self::VALUE_RI
     * @uses self::VALUE_LB
     * @uses self::VALUE_RB
     * @uses self::VALUE_N
     * @uses self::VALUE_NE
     * @uses self::VALUE_E
     * @uses self::VALUE_SE
     * @uses self::VALUE_S
     * @uses self::VALUE_SW
     * @uses self::VALUE_W
     * @uses self::VALUE_NW
     * @uses self::VALUE_BI
     * @uses self::VALUE_SM
     * @uses self::VALUE_OL
     * @uses self::VALUE_EW
     * @uses self::VALUE_MP
     * @uses self::VALUE_FP
     * @uses self::VALUE_VA
     * @uses self::VALUE_RY
     * @uses self::VALUE_GY
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_AL,
            self::VALUE_LE,
            self::VALUE_MI,
            self::VALUE_RI,
            self::VALUE_LB,
            self::VALUE_RB,
            self::VALUE_N,
            self::VALUE_NE,
            self::VALUE_E,
            self::VALUE_SE,
            self::VALUE_S,
            self::VALUE_SW,
            self::VALUE_W,
            self::VALUE_NW,
            self::VALUE_BI,
            self::VALUE_SM,
            self::VALUE_OL,
            self::VALUE_EW,
            self::VALUE_MP,
            self::VALUE_FP,
            self::VALUE_VA,
            self::VALUE_RY,
            self::VALUE_GY,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
