<?php

namespace EnumType;

/**
 * This class stands for ice_situation_code_enum EnumType
 * @subpackage Enumerations
 */
class Ice_situation_code_enum
{
    /**
     * Constant for value 'NOL'
     * @return string 'NOL'
     */
    const VALUE_NOL = 'NOL';
    /**
     * Constant for value 'LIM'
     * @return string 'LIM'
     */
    const VALUE_LIM = 'LIM';
    /**
     * Constant for value 'NON'
     * @return string 'NON'
     */
    const VALUE_NON = 'NON';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_NOL
     * @uses self::VALUE_LIM
     * @uses self::VALUE_NON
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_NOL,
            self::VALUE_LIM,
            self::VALUE_NON,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
