<?php

namespace EnumType;

/**
 * This class stands for error_code_type EnumType
 * @subpackage Enumerations
 */
class Error_code_type
{
    /**
     * Constant for value 'e010'
     * Meta information extracted from the WSDL
     * - documentation: Description: message type not supported, Explanation: web service does not support the requested message type
     * @return string 'e010'
     */
    const VALUE_E_010 = 'e010';
    /**
     * Constant for value 'e030'
     * Meta information extracted from the WSDL
     * - documentation: Description: paging parameters inconsistent with messages, Explanation: parameters for paging mechanism do not fit the available messages, e.g. Offset >= Total Count
     * @return string 'e030'
     */
    const VALUE_E_030 = 'e030';
    /**
     * Constant for value 'e100'
     * Meta information extracted from the WSDL
     * - documentation: Description: syntax error in request, Explanation: request violates the schema for requests
     * @return string 'e100'
     */
    const VALUE_E_100 = 'e100';
    /**
     * Constant for value 'e110'
     * Meta information extracted from the WSDL
     * - documentation: Description: incorrect message type, Explanation: given message type is not known
     * @return string 'e110'
     */
    const VALUE_E_110 = 'e110';
    /**
     * Constant for value 'e120'
     * Meta information extracted from the WSDL
     * - documentation: Description: incorrect type-specific parameters, Explanation: type-specific parameters are erroneous
     * @return string 'e120'
     */
    const VALUE_E_120 = 'e120';
    /**
     * Constant for value 'e130'
     * Meta information extracted from the WSDL
     * - documentation: Description: incorrect paging parameters, Explanation: given parameters for the paging mechanism are erroneous
     * @return string 'e130'
     */
    const VALUE_E_130 = 'e130';
    /**
     * Constant for value 'e200'
     * Meta information extracted from the WSDL
     * - documentation: Description: operation not known, Explanation: the requested operation is unknown
     * @return string 'e200'
     */
    const VALUE_E_200 = 'e200';
    /**
     * Constant for value 'e300'
     * Meta information extracted from the WSDL
     * - documentation: Description: data source unavailable, Explanation: data source of the web service for the NtS data is temporarily unavailable
     * @return string 'e300'
     */
    const VALUE_E_300 = 'e300';
    /**
     * Constant for value 'e310'
     * Meta information extracted from the WSDL
     * - documentation: Description: too many results for request, Explanation: server is unable to handle number of results
     * @return string 'e310'
     */
    const VALUE_E_310 = 'e310';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_E_010
     * @uses self::VALUE_E_030
     * @uses self::VALUE_E_100
     * @uses self::VALUE_E_110
     * @uses self::VALUE_E_120
     * @uses self::VALUE_E_130
     * @uses self::VALUE_E_200
     * @uses self::VALUE_E_300
     * @uses self::VALUE_E_310
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_E_010,
            self::VALUE_E_030,
            self::VALUE_E_100,
            self::VALUE_E_110,
            self::VALUE_E_120,
            self::VALUE_E_130,
            self::VALUE_E_200,
            self::VALUE_E_300,
            self::VALUE_E_310,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
