<?php

namespace EnumType;

/**
 * This class stands for direction_code_enum EnumType
 * @subpackage Enumerations
 */
class Direction_code_enum
{
    /**
     * Constant for value 'ALL'
     * @return string 'ALL'
     */
    const VALUE_ALL = 'ALL';
    /**
     * Constant for value 'UPS'
     * @return string 'UPS'
     */
    const VALUE_UPS = 'UPS';
    /**
     * Constant for value 'DWN'
     * @return string 'DWN'
     */
    const VALUE_DWN = 'DWN';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_ALL
     * @uses self::VALUE_UPS
     * @uses self::VALUE_DWN
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_ALL,
            self::VALUE_UPS,
            self::VALUE_DWN,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
