<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for werm_type StructType
 * @subpackage Structs
 */
class Werm_type extends AbstractStructBase
{
    /**
     * The internal_id
     * Meta information extracted from the WSDL
     * - documentation: Internal ID | Internal ID - best practice: global unique identifier
     * - base: xs:string
     * - maxLength: 64
     * - minOccurs: 0
     * @var string
     */
    public $internal_id;
    /**
     * The nts_number
     * Meta information extracted from the WSDL
     * - documentation: NtS Number
     * - minOccurs: 0
     * @var \StructType\Nts_number_type
     */
    public $nts_number;
    /**
     * The validity_period
     * Meta information extracted from the WSDL
     * - documentation: Overall period of validity
     * @var \StructType\Validity_period_type
     */
    public $validity_period;
    /**
     * The fairway_section
     * Meta information extracted from the WSDL
     * - documentation: Fairway section
     * @var \StructType\Fairway_section_werm_type
     */
    public $fairway_section;
    /**
     * The weather_report
     * Meta information extracted from the WSDL
     * - documentation: Actual or Forecast report sections
     * - maxOccurs: 2
     * @var \StructType\Weather_report_type[]
     */
    public $weather_report;
    /**
     * Constructor method for werm_type
     * @uses Werm_type::setInternal_id()
     * @uses Werm_type::setNts_number()
     * @uses Werm_type::setValidity_period()
     * @uses Werm_type::setFairway_section()
     * @uses Werm_type::setWeather_report()
     * @param string $internal_id
     * @param \StructType\Nts_number_type $nts_number
     * @param \StructType\Validity_period_type $validity_period
     * @param \StructType\Fairway_section_werm_type $fairway_section
     * @param \StructType\Weather_report_type[] $weather_report
     */
    public function __construct($internal_id = null, \StructType\Nts_number_type $nts_number = null, \StructType\Validity_period_type $validity_period = null, \StructType\Fairway_section_werm_type $fairway_section = null, array $weather_report = array())
    {
        $this
            ->setInternal_id($internal_id)
            ->setNts_number($nts_number)
            ->setValidity_period($validity_period)
            ->setFairway_section($fairway_section)
            ->setWeather_report($weather_report);
    }
    /**
     * Get internal_id value
     * @return string|null
     */
    public function getInternal_id()
    {
        return $this->internal_id;
    }
    /**
     * Set internal_id value
     * @param string $internal_id
     * @return \StructType\Werm_type
     */
    public function setInternal_id($internal_id = null)
    {
        // validation for constraint: string
        if (!is_null($internal_id) && !is_string($internal_id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($internal_id, true), gettype($internal_id)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($internal_id) && mb_strlen($internal_id) > 64) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen($internal_id)), __LINE__);
        }
        $this->internal_id = $internal_id;
        return $this;
    }
    /**
     * Get nts_number value
     * @return \StructType\Nts_number_type|null
     */
    public function getNts_number()
    {
        return $this->nts_number;
    }
    /**
     * Set nts_number value
     * @param \StructType\Nts_number_type $nts_number
     * @return \StructType\Werm_type
     */
    public function setNts_number(\StructType\Nts_number_type $nts_number = null)
    {
        $this->nts_number = $nts_number;
        return $this;
    }
    /**
     * Get validity_period value
     * @return \StructType\Validity_period_type|null
     */
    public function getValidity_period()
    {
        return $this->validity_period;
    }
    /**
     * Set validity_period value
     * @param \StructType\Validity_period_type $validity_period
     * @return \StructType\Werm_type
     */
    public function setValidity_period(\StructType\Validity_period_type $validity_period = null)
    {
        $this->validity_period = $validity_period;
        return $this;
    }
    /**
     * Get fairway_section value
     * @return \StructType\Fairway_section_werm_type|null
     */
    public function getFairway_section()
    {
        return $this->fairway_section;
    }
    /**
     * Set fairway_section value
     * @param \StructType\Fairway_section_werm_type $fairway_section
     * @return \StructType\Werm_type
     */
    public function setFairway_section(\StructType\Fairway_section_werm_type $fairway_section = null)
    {
        $this->fairway_section = $fairway_section;
        return $this;
    }
    /**
     * Get weather_report value
     * @return \StructType\Weather_report_type[]|null
     */
    public function getWeather_report()
    {
        return $this->weather_report;
    }
    /**
     * This method is responsible for validating the values passed to the setWeather_report method
     * This method is willingly generated in order to preserve the one-line inline validation within the setWeather_report method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateWeather_reportForArrayConstraintsFromSetWeather_report(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $werm_typeWeather_reportItem) {
            // validation for constraint: itemType
            if (!$werm_typeWeather_reportItem instanceof \StructType\Weather_report_type) {
                $invalidValues[] = is_object($werm_typeWeather_reportItem) ? get_class($werm_typeWeather_reportItem) : sprintf('%s(%s)', gettype($werm_typeWeather_reportItem), var_export($werm_typeWeather_reportItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The weather_report property can only contain items of type \StructType\Weather_report_type, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set weather_report value
     * @throws \InvalidArgumentException
     * @param \StructType\Weather_report_type[] $weather_report
     * @return \StructType\Werm_type
     */
    public function setWeather_report(array $weather_report = array())
    {
        // validation for constraint: array
        if ('' !== ($weather_reportArrayErrorMessage = self::validateWeather_reportForArrayConstraintsFromSetWeather_report($weather_report))) {
            throw new \InvalidArgumentException($weather_reportArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(2)
        if (is_array($weather_report) && count($weather_report) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 2', count($weather_report)), __LINE__);
        }
        $this->weather_report = $weather_report;
        return $this;
    }
    /**
     * Add item to weather_report value
     * @throws \InvalidArgumentException
     * @param \StructType\Weather_report_type $item
     * @return \StructType\Werm_type
     */
    public function addToWeather_report(\StructType\Weather_report_type $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Weather_report_type) {
            throw new \InvalidArgumentException(sprintf('The weather_report property can only contain items of type \StructType\Weather_report_type, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(2)
        if (is_array($this->weather_report) && count($this->weather_report) >= 2) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 2', count($this->weather_report)), __LINE__);
        }
        $this->weather_report[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Werm_type
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
