<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for weather_report_type StructType
 * @subpackage Structs
 */
class Weather_report_type extends AbstractStructBase
{
    /**
     * The measuredate
     * Meta information extracted from the WSDL
     * - documentation: Date and time of measurement or predicted value including timezone
     * - minOccurs: 0
     * @var string
     */
    public $measuredate;
    /**
     * The forecast
     * Meta information extracted from the WSDL
     * - documentation: Forecast (true or 1) OR Actual report (false or 0)
     * @var bool
     */
    public $forecast;
    /**
     * The weather_class_code
     * Meta information extracted from the WSDL
     * - documentation: Classification of weather report
     * - maxOccurs: unbounded
     * @var string[]
     */
    public $weather_class_code;
    /**
     * The weather_item
     * Meta information extracted from the WSDL
     * - documentation: Weather items
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Weather_item_type[]
     */
    public $weather_item;
    /**
     * Constructor method for weather_report_type
     * @uses Weather_report_type::setMeasuredate()
     * @uses Weather_report_type::setForecast()
     * @uses Weather_report_type::setWeather_class_code()
     * @uses Weather_report_type::setWeather_item()
     * @param string $measuredate
     * @param bool $forecast
     * @param string[] $weather_class_code
     * @param \StructType\Weather_item_type[] $weather_item
     */
    public function __construct($measuredate = null, $forecast = null, array $weather_class_code = array(), array $weather_item = array())
    {
        $this
            ->setMeasuredate($measuredate)
            ->setForecast($forecast)
            ->setWeather_class_code($weather_class_code)
            ->setWeather_item($weather_item);
    }
    /**
     * Get measuredate value
     * @return string|null
     */
    public function getMeasuredate()
    {
        return $this->measuredate;
    }
    /**
     * Set measuredate value
     * @param string $measuredate
     * @return \StructType\Weather_report_type
     */
    public function setMeasuredate($measuredate = null)
    {
        // validation for constraint: string
        if (!is_null($measuredate) && !is_string($measuredate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($measuredate, true), gettype($measuredate)), __LINE__);
        }
        $this->measuredate = $measuredate;
        return $this;
    }
    /**
     * Get forecast value
     * @return bool|null
     */
    public function getForecast()
    {
        return $this->forecast;
    }
    /**
     * Set forecast value
     * @param bool $forecast
     * @return \StructType\Weather_report_type
     */
    public function setForecast($forecast = null)
    {
        // validation for constraint: boolean
        if (!is_null($forecast) && !is_bool($forecast)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($forecast, true), gettype($forecast)), __LINE__);
        }
        $this->forecast = $forecast;
        return $this;
    }
    /**
     * Get weather_class_code value
     * @return string[]|null
     */
    public function getWeather_class_code()
    {
        return $this->weather_class_code;
    }
    /**
     * This method is responsible for validating the values passed to the setWeather_class_code method
     * This method is willingly generated in order to preserve the one-line inline validation within the setWeather_class_code method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateWeather_class_codeForArrayConstraintsFromSetWeather_class_code(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $weather_report_typeWeather_class_codeItem) {
            // validation for constraint: enumeration
            if (!\EnumType\Weather_class_code_enum::valueIsValid($weather_report_typeWeather_class_codeItem)) {
                $invalidValues[] = is_object($weather_report_typeWeather_class_codeItem) ? get_class($weather_report_typeWeather_class_codeItem) : sprintf('%s(%s)', gettype($weather_report_typeWeather_class_codeItem), var_export($weather_report_typeWeather_class_codeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\Weather_class_code_enum', is_array($invalidValues) ? implode(', ', $invalidValues) : var_export($invalidValues, true), implode(', ', \EnumType\Weather_class_code_enum::getValidValues()));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set weather_class_code value
     * @uses \EnumType\Weather_class_code_enum::valueIsValid()
     * @uses \EnumType\Weather_class_code_enum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $weather_class_code
     * @return \StructType\Weather_report_type
     */
    public function setWeather_class_code(array $weather_class_code = array())
    {
        // validation for constraint: array
        if ('' !== ($weather_class_codeArrayErrorMessage = self::validateWeather_class_codeForArrayConstraintsFromSetWeather_class_code($weather_class_code))) {
            throw new \InvalidArgumentException($weather_class_codeArrayErrorMessage, __LINE__);
        }
        $this->weather_class_code = $weather_class_code;
        return $this;
    }
    /**
     * Add item to weather_class_code value
     * @uses \EnumType\Weather_class_code_enum::valueIsValid()
     * @uses \EnumType\Weather_class_code_enum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\Weather_report_type
     */
    public function addToWeather_class_code($item)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Weather_class_code_enum::valueIsValid($item)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\Weather_class_code_enum', is_array($item) ? implode(', ', $item) : var_export($item, true), implode(', ', \EnumType\Weather_class_code_enum::getValidValues())), __LINE__);
        }
        $this->weather_class_code[] = $item;
        return $this;
    }
    /**
     * Get weather_item value
     * @return \StructType\Weather_item_type[]|null
     */
    public function getWeather_item()
    {
        return $this->weather_item;
    }
    /**
     * This method is responsible for validating the values passed to the setWeather_item method
     * This method is willingly generated in order to preserve the one-line inline validation within the setWeather_item method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateWeather_itemForArrayConstraintsFromSetWeather_item(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $weather_report_typeWeather_itemItem) {
            // validation for constraint: itemType
            if (!$weather_report_typeWeather_itemItem instanceof \StructType\Weather_item_type) {
                $invalidValues[] = is_object($weather_report_typeWeather_itemItem) ? get_class($weather_report_typeWeather_itemItem) : sprintf('%s(%s)', gettype($weather_report_typeWeather_itemItem), var_export($weather_report_typeWeather_itemItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The weather_item property can only contain items of type \StructType\Weather_item_type, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set weather_item value
     * @throws \InvalidArgumentException
     * @param \StructType\Weather_item_type[] $weather_item
     * @return \StructType\Weather_report_type
     */
    public function setWeather_item(array $weather_item = array())
    {
        // validation for constraint: array
        if ('' !== ($weather_itemArrayErrorMessage = self::validateWeather_itemForArrayConstraintsFromSetWeather_item($weather_item))) {
            throw new \InvalidArgumentException($weather_itemArrayErrorMessage, __LINE__);
        }
        $this->weather_item = $weather_item;
        return $this;
    }
    /**
     * Add item to weather_item value
     * @throws \InvalidArgumentException
     * @param \StructType\Weather_item_type $item
     * @return \StructType\Weather_report_type
     */
    public function addToWeather_item(\StructType\Weather_item_type $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Weather_item_type) {
            throw new \InvalidArgumentException(sprintf('The weather_item property can only contain items of type \StructType\Weather_item_type, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->weather_item[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Weather_report_type
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
