<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RIS_Message_Type StructType
 * Meta information extracted from the WSDL
 * - documentation: One msg contains one of these sections
 * @subpackage Structs
 */
class RIS_Message_Type extends AbstractStructBase
{
    /**
     * The identification
     * Meta information extracted from the WSDL
     * - documentation: Identification section
     * @var \StructType\Identification_type
     */
    public $identification;
    /**
     * The ftm
     * Meta information extracted from the WSDL
     * - documentation: Fairway and traffic related section
     * - choice: ftm | wrm | icem | werm
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: unbounded
     * @var \StructType\Ftm_type[]
     */
    public $ftm;
    /**
     * The wrm
     * Meta information extracted from the WSDL
     * - documentation: Water related section
     * - choice: ftm | wrm | icem | werm
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: unbounded
     * @var \StructType\Wrm_type[]
     */
    public $wrm;
    /**
     * The icem
     * Meta information extracted from the WSDL
     * - documentation: Ice related section
     * - choice: ftm | wrm | icem | werm
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: unbounded
     * @var \StructType\Icem_type[]
     */
    public $icem;
    /**
     * The werm
     * Meta information extracted from the WSDL
     * - documentation: Weather related section
     * - choice: ftm | wrm | icem | werm
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: unbounded
     * @var \StructType\Werm_type[]
     */
    public $werm;
    /**
     * Constructor method for RIS_Message_Type
     * @uses RIS_Message_Type::setIdentification()
     * @uses RIS_Message_Type::setFtm()
     * @uses RIS_Message_Type::setWrm()
     * @uses RIS_Message_Type::setIcem()
     * @uses RIS_Message_Type::setWerm()
     * @param \StructType\Identification_type $identification
     * @param \StructType\Ftm_type[] $ftm
     * @param \StructType\Wrm_type[] $wrm
     * @param \StructType\Icem_type[] $icem
     * @param \StructType\Werm_type[] $werm
     */
    public function __construct(\StructType\Identification_type $identification = null, array $ftm = array(), array $wrm = array(), array $icem = array(), array $werm = array())
    {
        $this
            ->setIdentification($identification)
            ->setFtm($ftm)
            ->setWrm($wrm)
            ->setIcem($icem)
            ->setWerm($werm);
    }
    /**
     * Get identification value
     * @return \StructType\Identification_type|null
     */
    public function getIdentification()
    {
        return $this->identification;
    }
    /**
     * Set identification value
     * @param \StructType\Identification_type $identification
     * @return \StructType\RIS_Message_Type
     */
    public function setIdentification(\StructType\Identification_type $identification = null)
    {
        $this->identification = $identification;
        return $this;
    }
    /**
     * Get ftm value
     * @return \StructType\Ftm_type[]|null
     */
    public function getFtm()
    {
        return isset($this->ftm) ? $this->ftm : null;
    }
    /**
     * This method is responsible for validating the values passed to the setFtm method
     * This method is willingly generated in order to preserve the one-line inline validation within the setFtm method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateFtmForArrayConstraintsFromSetFtm(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $rIS_Message_TypeFtmItem) {
            // validation for constraint: itemType
            if (!$rIS_Message_TypeFtmItem instanceof \StructType\Ftm_type) {
                $invalidValues[] = is_object($rIS_Message_TypeFtmItem) ? get_class($rIS_Message_TypeFtmItem) : sprintf('%s(%s)', gettype($rIS_Message_TypeFtmItem), var_export($rIS_Message_TypeFtmItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ftm property can only contain items of type \StructType\Ftm_type, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * This method is responsible for validating the value passed to the setFtm method
     * This method is willingly generated in order to preserve the one-line inline validation within the setFtm method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateFtmForChoiceConstraintsFromSetFtm($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'wrm',
            'icem',
            'werm',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property ftm can\'t be set as the property %s is already set. Only one property must be set among these properties: ftm, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set ftm value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @throws \InvalidArgumentException
     * @param \StructType\Ftm_type[] $ftm
     * @return \StructType\RIS_Message_Type
     */
    public function setFtm(array $ftm = array())
    {
        // validation for constraint: array
        if ('' !== ($ftmArrayErrorMessage = self::validateFtmForArrayConstraintsFromSetFtm($ftm))) {
            throw new \InvalidArgumentException($ftmArrayErrorMessage, __LINE__);
        }
        // validation for constraint: choice(ftm, wrm, icem, werm)
        if ('' !== ($ftmChoiceErrorMessage = self::validateFtmForChoiceConstraintsFromSetFtm($ftm))) {
            throw new \InvalidArgumentException($ftmChoiceErrorMessage, __LINE__);
        }
        if (is_null($ftm) || (is_array($ftm) && empty($ftm))) {
            unset($this->ftm);
        } else {
            $this->ftm = $ftm;
        }
        return $this;
    }
    /**
     * This method is responsible for validating the value passed to the addToFtm method
     * This method is willingly generated in order to preserve the one-line inline validation within the addToFtm method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateItemForChoiceConstraintsFromAddToFtm($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'wrm',
            'icem',
            'werm',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property ftm can\'t be set as the property %s is already set. Only one property must be set among these properties: ftm, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Add item to ftm value
     * @throws \InvalidArgumentException
     * @param \StructType\Ftm_type $item
     * @return \StructType\RIS_Message_Type
     */
    public function addToFtm(\StructType\Ftm_type $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Ftm_type) {
            throw new \InvalidArgumentException(sprintf('The ftm property can only contain items of type \StructType\Ftm_type, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: choice(ftm, wrm, icem, werm)
        if ('' !== ($itemChoiceErrorMessage = self::validateItemForChoiceConstraintsFromAddToFtm($item))) {
            throw new \InvalidArgumentException($itemChoiceErrorMessage, __LINE__);
        }
        $this->ftm[] = $item;
        return $this;
    }
    /**
     * Get wrm value
     * @return \StructType\Wrm_type[]|null
     */
    public function getWrm()
    {
        return isset($this->wrm) ? $this->wrm : null;
    }
    /**
     * This method is responsible for validating the values passed to the setWrm method
     * This method is willingly generated in order to preserve the one-line inline validation within the setWrm method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateWrmForArrayConstraintsFromSetWrm(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $rIS_Message_TypeWrmItem) {
            // validation for constraint: itemType
            if (!$rIS_Message_TypeWrmItem instanceof \StructType\Wrm_type) {
                $invalidValues[] = is_object($rIS_Message_TypeWrmItem) ? get_class($rIS_Message_TypeWrmItem) : sprintf('%s(%s)', gettype($rIS_Message_TypeWrmItem), var_export($rIS_Message_TypeWrmItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The wrm property can only contain items of type \StructType\Wrm_type, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * This method is responsible for validating the value passed to the setWrm method
     * This method is willingly generated in order to preserve the one-line inline validation within the setWrm method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateWrmForChoiceConstraintsFromSetWrm($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'ftm',
            'icem',
            'werm',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property wrm can\'t be set as the property %s is already set. Only one property must be set among these properties: wrm, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set wrm value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @throws \InvalidArgumentException
     * @param \StructType\Wrm_type[] $wrm
     * @return \StructType\RIS_Message_Type
     */
    public function setWrm(array $wrm = array())
    {
        // validation for constraint: array
        if ('' !== ($wrmArrayErrorMessage = self::validateWrmForArrayConstraintsFromSetWrm($wrm))) {
            throw new \InvalidArgumentException($wrmArrayErrorMessage, __LINE__);
        }
        // validation for constraint: choice(ftm, wrm, icem, werm)
        if ('' !== ($wrmChoiceErrorMessage = self::validateWrmForChoiceConstraintsFromSetWrm($wrm))) {
            throw new \InvalidArgumentException($wrmChoiceErrorMessage, __LINE__);
        }
        if (is_null($wrm) || (is_array($wrm) && empty($wrm))) {
            unset($this->wrm);
        } else {
            $this->wrm = $wrm;
        }
        return $this;
    }
    /**
     * This method is responsible for validating the value passed to the addToWrm method
     * This method is willingly generated in order to preserve the one-line inline validation within the addToWrm method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateItemForChoiceConstraintsFromAddToWrm($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'ftm',
            'icem',
            'werm',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property wrm can\'t be set as the property %s is already set. Only one property must be set among these properties: wrm, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Add item to wrm value
     * @throws \InvalidArgumentException
     * @param \StructType\Wrm_type $item
     * @return \StructType\RIS_Message_Type
     */
    public function addToWrm(\StructType\Wrm_type $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Wrm_type) {
            throw new \InvalidArgumentException(sprintf('The wrm property can only contain items of type \StructType\Wrm_type, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: choice(ftm, wrm, icem, werm)
        if ('' !== ($itemChoiceErrorMessage = self::validateItemForChoiceConstraintsFromAddToWrm($item))) {
            throw new \InvalidArgumentException($itemChoiceErrorMessage, __LINE__);
        }
        $this->wrm[] = $item;
        return $this;
    }
    /**
     * Get icem value
     * @return \StructType\Icem_type[]|null
     */
    public function getIcem()
    {
        return isset($this->icem) ? $this->icem : null;
    }
    /**
     * This method is responsible for validating the values passed to the setIcem method
     * This method is willingly generated in order to preserve the one-line inline validation within the setIcem method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateIcemForArrayConstraintsFromSetIcem(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $rIS_Message_TypeIcemItem) {
            // validation for constraint: itemType
            if (!$rIS_Message_TypeIcemItem instanceof \StructType\Icem_type) {
                $invalidValues[] = is_object($rIS_Message_TypeIcemItem) ? get_class($rIS_Message_TypeIcemItem) : sprintf('%s(%s)', gettype($rIS_Message_TypeIcemItem), var_export($rIS_Message_TypeIcemItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The icem property can only contain items of type \StructType\Icem_type, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * This method is responsible for validating the value passed to the setIcem method
     * This method is willingly generated in order to preserve the one-line inline validation within the setIcem method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateIcemForChoiceConstraintsFromSetIcem($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'ftm',
            'wrm',
            'werm',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property icem can\'t be set as the property %s is already set. Only one property must be set among these properties: icem, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set icem value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @throws \InvalidArgumentException
     * @param \StructType\Icem_type[] $icem
     * @return \StructType\RIS_Message_Type
     */
    public function setIcem(array $icem = array())
    {
        // validation for constraint: array
        if ('' !== ($icemArrayErrorMessage = self::validateIcemForArrayConstraintsFromSetIcem($icem))) {
            throw new \InvalidArgumentException($icemArrayErrorMessage, __LINE__);
        }
        // validation for constraint: choice(ftm, wrm, icem, werm)
        if ('' !== ($icemChoiceErrorMessage = self::validateIcemForChoiceConstraintsFromSetIcem($icem))) {
            throw new \InvalidArgumentException($icemChoiceErrorMessage, __LINE__);
        }
        if (is_null($icem) || (is_array($icem) && empty($icem))) {
            unset($this->icem);
        } else {
            $this->icem = $icem;
        }
        return $this;
    }
    /**
     * This method is responsible for validating the value passed to the addToIcem method
     * This method is willingly generated in order to preserve the one-line inline validation within the addToIcem method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateItemForChoiceConstraintsFromAddToIcem($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'ftm',
            'wrm',
            'werm',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property icem can\'t be set as the property %s is already set. Only one property must be set among these properties: icem, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Add item to icem value
     * @throws \InvalidArgumentException
     * @param \StructType\Icem_type $item
     * @return \StructType\RIS_Message_Type
     */
    public function addToIcem(\StructType\Icem_type $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Icem_type) {
            throw new \InvalidArgumentException(sprintf('The icem property can only contain items of type \StructType\Icem_type, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: choice(ftm, wrm, icem, werm)
        if ('' !== ($itemChoiceErrorMessage = self::validateItemForChoiceConstraintsFromAddToIcem($item))) {
            throw new \InvalidArgumentException($itemChoiceErrorMessage, __LINE__);
        }
        $this->icem[] = $item;
        return $this;
    }
    /**
     * Get werm value
     * @return \StructType\Werm_type[]|null
     */
    public function getWerm()
    {
        return isset($this->werm) ? $this->werm : null;
    }
    /**
     * This method is responsible for validating the values passed to the setWerm method
     * This method is willingly generated in order to preserve the one-line inline validation within the setWerm method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateWermForArrayConstraintsFromSetWerm(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $rIS_Message_TypeWermItem) {
            // validation for constraint: itemType
            if (!$rIS_Message_TypeWermItem instanceof \StructType\Werm_type) {
                $invalidValues[] = is_object($rIS_Message_TypeWermItem) ? get_class($rIS_Message_TypeWermItem) : sprintf('%s(%s)', gettype($rIS_Message_TypeWermItem), var_export($rIS_Message_TypeWermItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The werm property can only contain items of type \StructType\Werm_type, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * This method is responsible for validating the value passed to the setWerm method
     * This method is willingly generated in order to preserve the one-line inline validation within the setWerm method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateWermForChoiceConstraintsFromSetWerm($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'ftm',
            'wrm',
            'icem',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property werm can\'t be set as the property %s is already set. Only one property must be set among these properties: werm, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set werm value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @throws \InvalidArgumentException
     * @param \StructType\Werm_type[] $werm
     * @return \StructType\RIS_Message_Type
     */
    public function setWerm(array $werm = array())
    {
        // validation for constraint: array
        if ('' !== ($wermArrayErrorMessage = self::validateWermForArrayConstraintsFromSetWerm($werm))) {
            throw new \InvalidArgumentException($wermArrayErrorMessage, __LINE__);
        }
        // validation for constraint: choice(ftm, wrm, icem, werm)
        if ('' !== ($wermChoiceErrorMessage = self::validateWermForChoiceConstraintsFromSetWerm($werm))) {
            throw new \InvalidArgumentException($wermChoiceErrorMessage, __LINE__);
        }
        if (is_null($werm) || (is_array($werm) && empty($werm))) {
            unset($this->werm);
        } else {
            $this->werm = $werm;
        }
        return $this;
    }
    /**
     * This method is responsible for validating the value passed to the addToWerm method
     * This method is willingly generated in order to preserve the one-line inline validation within the addToWerm method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateItemForChoiceConstraintsFromAddToWerm($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'ftm',
            'wrm',
            'icem',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property werm can\'t be set as the property %s is already set. Only one property must be set among these properties: werm, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Add item to werm value
     * @throws \InvalidArgumentException
     * @param \StructType\Werm_type $item
     * @return \StructType\RIS_Message_Type
     */
    public function addToWerm(\StructType\Werm_type $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Werm_type) {
            throw new \InvalidArgumentException(sprintf('The werm property can only contain items of type \StructType\Werm_type, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: choice(ftm, wrm, icem, werm)
        if ('' !== ($itemChoiceErrorMessage = self::validateItemForChoiceConstraintsFromAddToWerm($item))) {
            throw new \InvalidArgumentException($itemChoiceErrorMessage, __LINE__);
        }
        $this->werm[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RIS_Message_Type
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
