<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for nts_number_type StructType
 * @subpackage Structs
 */
class Nts_number_type extends AbstractStructBase
{
    /**
     * The organisation
     * Meta information extracted from the WSDL
     * - documentation: Name of the publishing organisation (NtS Provider)
     * - base: xs:string
     * - maxLength: 64
     * @var string
     */
    public $organisation;
    /**
     * The year
     * Meta information extracted from the WSDL
     * - documentation: Year of first issuing of the notice
     * - base: xs:gYear
     * - maxInclusive: 9999
     * - minInclusive: 1900
     * @var string
     */
    public $year;
    /**
     * The number
     * Meta information extracted from the WSDL
     * - documentation: Telephone, VHF number (including callsign), e-mail address, URL or teletext | Number of the notice (per year, starting with: 1, 0 shall not be used for published notices)
     * - base: xs:integer
     * - maxInclusive: 99999999
     * - minInclusive: 00000000
     * @var int
     */
    public $number;
    /**
     * The serial_number
     * Meta information extracted from the WSDL
     * - documentation: Serial number of notice (replacements and withdrawals), original notice: 0
     * - base: xs:integer
     * - maxInclusive: 99
     * - minInclusive: 00
     * @var int
     */
    public $serial_number;
    /**
     * Constructor method for nts_number_type
     * @uses Nts_number_type::setOrganisation()
     * @uses Nts_number_type::setYear()
     * @uses Nts_number_type::setNumber()
     * @uses Nts_number_type::setSerial_number()
     * @param string $organisation
     * @param string $year
     * @param int $number
     * @param int $serial_number
     */
    public function __construct($organisation = null, $year = null, $number = null, $serial_number = null)
    {
        $this
            ->setOrganisation($organisation)
            ->setYear($year)
            ->setNumber($number)
            ->setSerial_number($serial_number);
    }
    /**
     * Get organisation value
     * @return string|null
     */
    public function getOrganisation()
    {
        return $this->organisation;
    }
    /**
     * Set organisation value
     * @param string $organisation
     * @return \StructType\Nts_number_type
     */
    public function setOrganisation($organisation = null)
    {
        // validation for constraint: string
        if (!is_null($organisation) && !is_string($organisation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($organisation, true), gettype($organisation)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($organisation) && mb_strlen($organisation) > 64) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen($organisation)), __LINE__);
        }
        $this->organisation = $organisation;
        return $this;
    }
    /**
     * Get year value
     * @return string|null
     */
    public function getYear()
    {
        return $this->year;
    }
    /**
     * Set year value
     * @param string $year
     * @return \StructType\Nts_number_type
     */
    public function setYear($year = null)
    {
        // validation for constraint: string
        if (!is_null($year) && !is_string($year)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($year, true), gettype($year)), __LINE__);
        }
        // validation for constraint: maxInclusive(9999)
        if (!is_null($year) && $year > 9999) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 9999', var_export($year, true)), __LINE__);
        }
        // validation for constraint: minInclusive(1900)
        if (!is_null($year) && $year < 1900) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 1900', var_export($year, true)), __LINE__);
        }
        $this->year = $year;
        return $this;
    }
    /**
     * Get number value
     * @return int|null
     */
    public function getNumber()
    {
        return $this->number;
    }
    /**
     * Set number value
     * @param int $number
     * @return \StructType\Nts_number_type
     */
    public function setNumber($number = null)
    {
        // validation for constraint: int
        if (!is_null($number) && !(is_int($number) || ctype_digit($number))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($number, true), gettype($number)), __LINE__);
        }
        // validation for constraint: maxInclusive(99999999)
        if (!is_null($number) && $number > 99999999) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 99999999', var_export($number, true)), __LINE__);
        }
        // validation for constraint: minInclusive(00000000)
        if (!is_null($number) && $number < 00000000) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 00000000', var_export($number, true)), __LINE__);
        }
        $this->number = $number;
        return $this;
    }
    /**
     * Get serial_number value
     * @return int|null
     */
    public function getSerial_number()
    {
        return $this->serial_number;
    }
    /**
     * Set serial_number value
     * @param int $serial_number
     * @return \StructType\Nts_number_type
     */
    public function setSerial_number($serial_number = null)
    {
        // validation for constraint: int
        if (!is_null($serial_number) && !(is_int($serial_number) || ctype_digit($serial_number))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($serial_number, true), gettype($serial_number)), __LINE__);
        }
        // validation for constraint: maxInclusive(99)
        if (!is_null($serial_number) && $serial_number > 99) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 99', var_export($serial_number, true)), __LINE__);
        }
        // validation for constraint: minInclusive(00)
        if (!is_null($serial_number) && $serial_number < 00) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 00', var_export($serial_number, true)), __LINE__);
        }
        $this->serial_number = $serial_number;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Nts_number_type
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
