<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for limitation_type StructType
 * @subpackage Structs
 */
class Limitation_type extends AbstractStructBase
{
    /**
     * The limitation_period
     * Meta information extracted from the WSDL
     * - documentation: Limitation periods / intervals
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Limitation_period_type[]
     */
    public $limitation_period;
    /**
     * The limitation_code
     * Meta information extracted from the WSDL
     * - documentation: Kind of limitation
     * @var string
     */
    public $limitation_code;
    /**
     * The position_code
     * Meta information extracted from the WSDL
     * - documentation: Describes the position of the limitation related to the fairway
     * - minOccurs: 0
     * @var string
     */
    public $position_code;
    /**
     * The value
     * Meta information extracted from the WSDL
     * - documentation: Value of limitation (i.e. max draught)
     * - minOccurs: 0
     * @var float
     */
    public $value;
    /**
     * The unit
     * Meta information extracted from the WSDL
     * - documentation: Unit of the value of the limitation
     * - minOccurs: 0
     * @var string
     */
    public $unit;
    /**
     * The reference_code
     * Meta information extracted from the WSDL
     * - documentation: Value reference
     * - minOccurs: 0
     * @var string
     */
    public $reference_code;
    /**
     * The indication_code
     * Meta information extracted from the WSDL
     * - documentation: Minimum or maximum or reduced by
     * - minOccurs: 0
     * @var string
     */
    public $indication_code;
    /**
     * The target_group
     * Meta information extracted from the WSDL
     * - documentation: Target group information
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Target_group_type[]
     */
    public $target_group;
    /**
     * Constructor method for limitation_type
     * @uses Limitation_type::setLimitation_period()
     * @uses Limitation_type::setLimitation_code()
     * @uses Limitation_type::setPosition_code()
     * @uses Limitation_type::setValue()
     * @uses Limitation_type::setUnit()
     * @uses Limitation_type::setReference_code()
     * @uses Limitation_type::setIndication_code()
     * @uses Limitation_type::setTarget_group()
     * @param \StructType\Limitation_period_type[] $limitation_period
     * @param string $limitation_code
     * @param string $position_code
     * @param float $value
     * @param string $unit
     * @param string $reference_code
     * @param string $indication_code
     * @param \StructType\Target_group_type[] $target_group
     */
    public function __construct(array $limitation_period = array(), $limitation_code = null, $position_code = null, $value = null, $unit = null, $reference_code = null, $indication_code = null, array $target_group = array())
    {
        $this
            ->setLimitation_period($limitation_period)
            ->setLimitation_code($limitation_code)
            ->setPosition_code($position_code)
            ->setValue($value)
            ->setUnit($unit)
            ->setReference_code($reference_code)
            ->setIndication_code($indication_code)
            ->setTarget_group($target_group);
    }
    /**
     * Get limitation_period value
     * @return \StructType\Limitation_period_type[]|null
     */
    public function getLimitation_period()
    {
        return $this->limitation_period;
    }
    /**
     * This method is responsible for validating the values passed to the setLimitation_period method
     * This method is willingly generated in order to preserve the one-line inline validation within the setLimitation_period method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateLimitation_periodForArrayConstraintsFromSetLimitation_period(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $limitation_typeLimitation_periodItem) {
            // validation for constraint: itemType
            if (!$limitation_typeLimitation_periodItem instanceof \StructType\Limitation_period_type) {
                $invalidValues[] = is_object($limitation_typeLimitation_periodItem) ? get_class($limitation_typeLimitation_periodItem) : sprintf('%s(%s)', gettype($limitation_typeLimitation_periodItem), var_export($limitation_typeLimitation_periodItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The limitation_period property can only contain items of type \StructType\Limitation_period_type, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set limitation_period value
     * @throws \InvalidArgumentException
     * @param \StructType\Limitation_period_type[] $limitation_period
     * @return \StructType\Limitation_type
     */
    public function setLimitation_period(array $limitation_period = array())
    {
        // validation for constraint: array
        if ('' !== ($limitation_periodArrayErrorMessage = self::validateLimitation_periodForArrayConstraintsFromSetLimitation_period($limitation_period))) {
            throw new \InvalidArgumentException($limitation_periodArrayErrorMessage, __LINE__);
        }
        $this->limitation_period = $limitation_period;
        return $this;
    }
    /**
     * Add item to limitation_period value
     * @throws \InvalidArgumentException
     * @param \StructType\Limitation_period_type $item
     * @return \StructType\Limitation_type
     */
    public function addToLimitation_period(\StructType\Limitation_period_type $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Limitation_period_type) {
            throw new \InvalidArgumentException(sprintf('The limitation_period property can only contain items of type \StructType\Limitation_period_type, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->limitation_period[] = $item;
        return $this;
    }
    /**
     * Get limitation_code value
     * @return string|null
     */
    public function getLimitation_code()
    {
        return $this->limitation_code;
    }
    /**
     * Set limitation_code value
     * @uses \EnumType\Limitation_code_enum::valueIsValid()
     * @uses \EnumType\Limitation_code_enum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $limitation_code
     * @return \StructType\Limitation_type
     */
    public function setLimitation_code($limitation_code = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Limitation_code_enum::valueIsValid($limitation_code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\Limitation_code_enum', is_array($limitation_code) ? implode(', ', $limitation_code) : var_export($limitation_code, true), implode(', ', \EnumType\Limitation_code_enum::getValidValues())), __LINE__);
        }
        $this->limitation_code = $limitation_code;
        return $this;
    }
    /**
     * Get position_code value
     * @return string|null
     */
    public function getPosition_code()
    {
        return $this->position_code;
    }
    /**
     * Set position_code value
     * @uses \EnumType\Position_code_enum::valueIsValid()
     * @uses \EnumType\Position_code_enum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $position_code
     * @return \StructType\Limitation_type
     */
    public function setPosition_code($position_code = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Position_code_enum::valueIsValid($position_code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\Position_code_enum', is_array($position_code) ? implode(', ', $position_code) : var_export($position_code, true), implode(', ', \EnumType\Position_code_enum::getValidValues())), __LINE__);
        }
        $this->position_code = $position_code;
        return $this;
    }
    /**
     * Get value value
     * @return float|null
     */
    public function getValue()
    {
        return $this->value;
    }
    /**
     * Set value value
     * @param float $value
     * @return \StructType\Limitation_type
     */
    public function setValue($value = null)
    {
        // validation for constraint: float
        if (!is_null($value) && !(is_float($value) || is_numeric($value))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($value, true), gettype($value)), __LINE__);
        }
        $this->value = $value;
        return $this;
    }
    /**
     * Get unit value
     * @return string|null
     */
    public function getUnit()
    {
        return $this->unit;
    }
    /**
     * Set unit value
     * @uses \EnumType\Unit_enum::valueIsValid()
     * @uses \EnumType\Unit_enum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $unit
     * @return \StructType\Limitation_type
     */
    public function setUnit($unit = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Unit_enum::valueIsValid($unit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\Unit_enum', is_array($unit) ? implode(', ', $unit) : var_export($unit, true), implode(', ', \EnumType\Unit_enum::getValidValues())), __LINE__);
        }
        $this->unit = $unit;
        return $this;
    }
    /**
     * Get reference_code value
     * @return string|null
     */
    public function getReference_code()
    {
        return $this->reference_code;
    }
    /**
     * Set reference_code value
     * @uses \EnumType\Reference_code_enum::valueIsValid()
     * @uses \EnumType\Reference_code_enum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $reference_code
     * @return \StructType\Limitation_type
     */
    public function setReference_code($reference_code = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Reference_code_enum::valueIsValid($reference_code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\Reference_code_enum', is_array($reference_code) ? implode(', ', $reference_code) : var_export($reference_code, true), implode(', ', \EnumType\Reference_code_enum::getValidValues())), __LINE__);
        }
        $this->reference_code = $reference_code;
        return $this;
    }
    /**
     * Get indication_code value
     * @return string|null
     */
    public function getIndication_code()
    {
        return $this->indication_code;
    }
    /**
     * Set indication_code value
     * @uses \EnumType\Indication_code_enum::valueIsValid()
     * @uses \EnumType\Indication_code_enum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $indication_code
     * @return \StructType\Limitation_type
     */
    public function setIndication_code($indication_code = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Indication_code_enum::valueIsValid($indication_code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\Indication_code_enum', is_array($indication_code) ? implode(', ', $indication_code) : var_export($indication_code, true), implode(', ', \EnumType\Indication_code_enum::getValidValues())), __LINE__);
        }
        $this->indication_code = $indication_code;
        return $this;
    }
    /**
     * Get target_group value
     * @return \StructType\Target_group_type[]|null
     */
    public function getTarget_group()
    {
        return $this->target_group;
    }
    /**
     * This method is responsible for validating the values passed to the setTarget_group method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTarget_group method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTarget_groupForArrayConstraintsFromSetTarget_group(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $limitation_typeTarget_groupItem) {
            // validation for constraint: itemType
            if (!$limitation_typeTarget_groupItem instanceof \StructType\Target_group_type) {
                $invalidValues[] = is_object($limitation_typeTarget_groupItem) ? get_class($limitation_typeTarget_groupItem) : sprintf('%s(%s)', gettype($limitation_typeTarget_groupItem), var_export($limitation_typeTarget_groupItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The target_group property can only contain items of type \StructType\Target_group_type, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set target_group value
     * @throws \InvalidArgumentException
     * @param \StructType\Target_group_type[] $target_group
     * @return \StructType\Limitation_type
     */
    public function setTarget_group(array $target_group = array())
    {
        // validation for constraint: array
        if ('' !== ($target_groupArrayErrorMessage = self::validateTarget_groupForArrayConstraintsFromSetTarget_group($target_group))) {
            throw new \InvalidArgumentException($target_groupArrayErrorMessage, __LINE__);
        }
        $this->target_group = $target_group;
        return $this;
    }
    /**
     * Add item to target_group value
     * @throws \InvalidArgumentException
     * @param \StructType\Target_group_type $item
     * @return \StructType\Limitation_type
     */
    public function addToTarget_group(\StructType\Target_group_type $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Target_group_type) {
            throw new \InvalidArgumentException(sprintf('The target_group property can only contain items of type \StructType\Target_group_type, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->target_group[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Limitation_type
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
