<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for id_pair StructType
 * @subpackage Structs
 */
class Id_pair extends AbstractStructBase
{
    /**
     * The id
     * Meta information extracted from the WSDL
     * - documentation: ISRS location code, unique identification of the geo object as defined in RIS Index encoding guide
     * - base: xs:string
     * - length: 20
     * - maxOccurs: 2
     * - minOccurs: 1
     * - pattern: [A-Z]{2}[A-Z]{3}[A-Z0-9]{5}[A-Z0-9]{5}[0-9]{5}
     * @var string[]
     */
    public $id;
    /**
     * Constructor method for id_pair
     * @uses Id_pair::setId()
     * @param string[] $id
     */
    public function __construct(array $id = array())
    {
        $this
            ->setId($id);
    }
    /**
     * Get id value
     * @return string[]
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * This method is responsible for validating the values passed to the setId method
     * This method is willingly generated in order to preserve the one-line inline validation within the setId method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateIdForArrayConstraintsFromSetId(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $id_pairIdItem) {
            // validation for constraint: itemType
            if (!is_string($id_pairIdItem)) {
                $invalidValues[] = is_object($id_pairIdItem) ? get_class($id_pairIdItem) : sprintf('%s(%s)', gettype($id_pairIdItem), var_export($id_pairIdItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The id property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * This method is responsible for validating the value passed to the setId method
     * This method is willingly generated in order to preserve the one-line inline validation within the setId method
     * This has to validate that the items contained by the array match the length constraint
     * @param mixed $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateIdForLengthConstraintFromSetId($values)
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $id_pairIdItem) {
            // validation for constraint: length(20)
            if (mb_strlen($id_pairIdItem) !== 20) {
                $invalidValues[] = var_export($id_pairIdItem, true);
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid length for value(s) %s, the number of characters/octets contained by the literal must be equal to 20', implode(', ', $invalidValues));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set id value
     * @throws \InvalidArgumentException
     * @param string[] $id
     * @return \StructType\Id_pair
     */
    public function setId(array $id = array())
    {
        // validation for constraint: array
        if ('' !== ($idArrayErrorMessage = self::validateIdForArrayConstraintsFromSetId($id))) {
            throw new \InvalidArgumentException($idArrayErrorMessage, __LINE__);
        }
        // validation for constraint: length(20)
        if ('' !== ($idLengthErrorMessage = self::validateIdForLengthConstraintFromSetId($id))) {
            throw new \InvalidArgumentException($idLengthErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(2)
        if (is_array($id) && count($id) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 2', count($id)), __LINE__);
        }
        // validation for constraint: pattern([A-Z]{2}[A-Z]{3}[A-Z0-9]{5}[A-Z0-9]{5}[0-9]{5})
        if (!is_null($id) && !preg_match('/[A-Z]{2}[A-Z]{3}[A-Z0-9]{5}[A-Z0-9]{5}[0-9]{5}/', $id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [A-Z]{2}[A-Z]{3}[A-Z0-9]{5}[A-Z0-9]{5}[0-9]{5}', var_export($id, true)), __LINE__);
        }
        $this->id = $id;
        return $this;
    }
    /**
     * Add item to id value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\Id_pair
     */
    public function addToId($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The id property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: length(20)
        if (mb_strlen($item) !== 20) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 20', mb_strlen($item)), __LINE__);
        }
        // validation for constraint: maxOccurs(2)
        if (is_array($this->id) && count($this->id) >= 2) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 2', count($this->id)), __LINE__);
        }
        // validation for constraint: pattern([A-Z]{2}[A-Z]{3}[A-Z0-9]{5}[A-Z0-9]{5}[0-9]{5})
        if (!preg_match('/[A-Z]{2}[A-Z]{3}[A-Z0-9]{5}[A-Z0-9]{5}[0-9]{5}/', $item)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [A-Z]{2}[A-Z]{3}[A-Z0-9]{5}[A-Z0-9]{5}[0-9]{5}', var_export($item, true)), __LINE__);
        }
        $this->id[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Id_pair
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
