<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for communication_type StructType
 * @subpackage Structs
 */
class Communication_type extends AbstractStructBase
{
    /**
     * The reporting_code
     * Meta information extracted from the WSDL
     * - documentation: Reporting regime (information, or duty to report)
     * @var string
     */
    public $reporting_code;
    /**
     * The communication_code
     * Meta information extracted from the WSDL
     * - documentation: Communication code (telephone, VHF etc.)
     * @var string
     */
    public $communication_code;
    /**
     * The number
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 128
     * - minOccurs: 0
     * @var string
     */
    public $number;
    /**
     * The label
     * Meta information extracted from the WSDL
     * - documentation: Name of the attachment or additional information
     * - base: xs:string
     * - maxLength: 256
     * - minOccurs: 0
     * @var string
     */
    public $label;
    /**
     * The remark
     * Meta information extracted from the WSDL
     * - documentation: Additional remarks concerning the communication
     * - base: xs:string
     * - maxLength: 1024
     * - minOccurs: 0
     * @var string
     */
    public $remark;
    /**
     * Constructor method for communication_type
     * @uses Communication_type::setReporting_code()
     * @uses Communication_type::setCommunication_code()
     * @uses Communication_type::setNumber()
     * @uses Communication_type::setLabel()
     * @uses Communication_type::setRemark()
     * @param string $reporting_code
     * @param string $communication_code
     * @param string $number
     * @param string $label
     * @param string $remark
     */
    public function __construct($reporting_code = null, $communication_code = null, $number = null, $label = null, $remark = null)
    {
        $this
            ->setReporting_code($reporting_code)
            ->setCommunication_code($communication_code)
            ->setNumber($number)
            ->setLabel($label)
            ->setRemark($remark);
    }
    /**
     * Get reporting_code value
     * @return string|null
     */
    public function getReporting_code()
    {
        return $this->reporting_code;
    }
    /**
     * Set reporting_code value
     * @uses \EnumType\Reporting_code_enum::valueIsValid()
     * @uses \EnumType\Reporting_code_enum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $reporting_code
     * @return \StructType\Communication_type
     */
    public function setReporting_code($reporting_code = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Reporting_code_enum::valueIsValid($reporting_code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\Reporting_code_enum', is_array($reporting_code) ? implode(', ', $reporting_code) : var_export($reporting_code, true), implode(', ', \EnumType\Reporting_code_enum::getValidValues())), __LINE__);
        }
        $this->reporting_code = $reporting_code;
        return $this;
    }
    /**
     * Get communication_code value
     * @return string|null
     */
    public function getCommunication_code()
    {
        return $this->communication_code;
    }
    /**
     * Set communication_code value
     * @uses \EnumType\Communication_code_enum::valueIsValid()
     * @uses \EnumType\Communication_code_enum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $communication_code
     * @return \StructType\Communication_type
     */
    public function setCommunication_code($communication_code = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Communication_code_enum::valueIsValid($communication_code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\Communication_code_enum', is_array($communication_code) ? implode(', ', $communication_code) : var_export($communication_code, true), implode(', ', \EnumType\Communication_code_enum::getValidValues())), __LINE__);
        }
        $this->communication_code = $communication_code;
        return $this;
    }
    /**
     * Get number value
     * @return string|null
     */
    public function getNumber()
    {
        return $this->number;
    }
    /**
     * Set number value
     * @param string $number
     * @return \StructType\Communication_type
     */
    public function setNumber($number = null)
    {
        // validation for constraint: string
        if (!is_null($number) && !is_string($number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($number, true), gettype($number)), __LINE__);
        }
        // validation for constraint: maxLength(128)
        if (!is_null($number) && mb_strlen($number) > 128) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 128', mb_strlen($number)), __LINE__);
        }
        $this->number = $number;
        return $this;
    }
    /**
     * Get label value
     * @return string|null
     */
    public function getLabel()
    {
        return $this->label;
    }
    /**
     * Set label value
     * @param string $label
     * @return \StructType\Communication_type
     */
    public function setLabel($label = null)
    {
        // validation for constraint: string
        if (!is_null($label) && !is_string($label)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($label, true), gettype($label)), __LINE__);
        }
        // validation for constraint: maxLength(256)
        if (!is_null($label) && mb_strlen($label) > 256) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 256', mb_strlen($label)), __LINE__);
        }
        $this->label = $label;
        return $this;
    }
    /**
     * Get remark value
     * @return string|null
     */
    public function getRemark()
    {
        return $this->remark;
    }
    /**
     * Set remark value
     * @param string $remark
     * @return \StructType\Communication_type
     */
    public function setRemark($remark = null)
    {
        // validation for constraint: string
        if (!is_null($remark) && !is_string($remark)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($remark, true), gettype($remark)), __LINE__);
        }
        // validation for constraint: maxLength(1024)
        if (!is_null($remark) && mb_strlen($remark) > 1024) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 1024', mb_strlen($remark)), __LINE__);
        }
        $this->remark = $remark;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Communication_type
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
