<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Getmessages ServiceType
 * @subpackage Services
 */
class Getmessages extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named get_messages
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Get_messages_query $parameters
     * @return \StructType\Get_messages_result|bool
     */
    public function get_messages(\StructType\Get_messages_query $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->get_messages($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\Get_messages_result
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
