<?php

namespace EnumType;

/**
 * This class stands for unit_enum EnumType
 * @subpackage Enumerations
 */
class Unit_enum
{
    /**
     * Constant for value 'cm'
     * @return string 'cm'
     */
    const VALUE_CM = 'cm';
    /**
     * Constant for value 'm³/s'
     * @return string 'm³/s'
     */
    const VALUE_M_³_S = 'm³/s';
    /**
     * Constant for value 'h'
     * @return string 'h'
     */
    const VALUE_H = 'h';
    /**
     * Constant for value 'km/h'
     * @return string 'km/h'
     */
    const VALUE_KM_H = 'km/h';
    /**
     * Constant for value 'kW'
     * @return string 'kW'
     */
    const VALUE_K_W = 'kW';
    /**
     * Constant for value 'm/s'
     * @return string 'm/s'
     */
    const VALUE_M_S = 'm/s';
    /**
     * Constant for value 'mm/h'
     * @return string 'mm/h'
     */
    const VALUE_MM_H = 'mm/h';
    /**
     * Constant for value '°C'
     * @return string '°C'
     */
    const VALUE_C = '°C';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_CM
     * @uses self::VALUE_M_³_S
     * @uses self::VALUE_H
     * @uses self::VALUE_KM_H
     * @uses self::VALUE_K_W
     * @uses self::VALUE_M_S
     * @uses self::VALUE_MM_H
     * @uses self::VALUE_C
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_CM,
            self::VALUE_M_³_S,
            self::VALUE_H,
            self::VALUE_KM_H,
            self::VALUE_K_W,
            self::VALUE_M_S,
            self::VALUE_MM_H,
            self::VALUE_C,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
