<?php

namespace EnumType;

/**
 * This class stands for indication_code_enum EnumType
 * @subpackage Enumerations
 */
class Indication_code_enum
{
    /**
     * Constant for value 'MAX'
     * @return string 'MAX'
     */
    const VALUE_MAX = 'MAX';
    /**
     * Constant for value 'MIN'
     * @return string 'MIN'
     */
    const VALUE_MIN = 'MIN';
    /**
     * Constant for value 'RED'
     * @return string 'RED'
     */
    const VALUE_RED = 'RED';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_MAX
     * @uses self::VALUE_MIN
     * @uses self::VALUE_RED
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_MAX,
            self::VALUE_MIN,
            self::VALUE_RED,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
