<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CityInformation StructType
 * @subpackage Structs
 */
class CityInformation extends AbstractStructBase
{
    /**
     * The province_code
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $province_code;
    /**
     * The province_name
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $province_name;
    /**
     * Constructor method for CityInformation
     * @uses CityInformation::setProvince_code()
     * @uses CityInformation::setProvince_name()
     * @param int $province_code
     * @param string $province_name
     */
    public function __construct($province_code = null, $province_name = null)
    {
        $this
            ->setProvince_code($province_code)
            ->setProvince_name($province_name);
    }
    /**
     * Get province_code value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getProvince_code()
    {
        return isset($this->province_code) ? $this->province_code : null;
    }
    /**
     * Set province_code value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $province_code
     * @return \StructType\CityInformation
     */
    public function setProvince_code($province_code = null)
    {
        // validation for constraint: int
        if (!is_null($province_code) && !(is_int($province_code) || ctype_digit($province_code))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($province_code, true), gettype($province_code)), __LINE__);
        }
        if (is_null($province_code) || (is_array($province_code) && empty($province_code))) {
            unset($this->province_code);
        } else {
            $this->province_code = $province_code;
        }
        return $this;
    }
    /**
     * Get province_name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getProvince_name()
    {
        return isset($this->province_name) ? $this->province_name : null;
    }
    /**
     * Set province_name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $province_name
     * @return \StructType\CityInformation
     */
    public function setProvince_name($province_name = null)
    {
        // validation for constraint: string
        if (!is_null($province_name) && !is_string($province_name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($province_name, true), gettype($province_name)), __LINE__);
        }
        if (is_null($province_name) || (is_array($province_name) && empty($province_name))) {
            unset($this->province_name);
        } else {
            $this->province_name = $province_name;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CityInformation
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
