<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OutputDistrict StructType
 * @subpackage Structs
 */
class OutputDistrict extends AbstractStructBase
{
    /**
     * The code
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $code;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $description;
    /**
     * The information
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DistrictInformation[]
     */
    public $information;
    /**
     * Constructor method for OutputDistrict
     * @uses OutputDistrict::setCode()
     * @uses OutputDistrict::setDescription()
     * @uses OutputDistrict::setInformation()
     * @param int $code
     * @param string $description
     * @param \StructType\DistrictInformation[] $information
     */
    public function __construct($code = null, $description = null, array $information = array())
    {
        $this
            ->setCode($code)
            ->setDescription($description)
            ->setInformation($information);
    }
    /**
     * Get code value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getCode()
    {
        return isset($this->code) ? $this->code : null;
    }
    /**
     * Set code value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $code
     * @return \StructType\OutputDistrict
     */
    public function setCode($code = null)
    {
        // validation for constraint: int
        if (!is_null($code) && !(is_int($code) || ctype_digit($code))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($code, true), gettype($code)), __LINE__);
        }
        if (is_null($code) || (is_array($code) && empty($code))) {
            unset($this->code);
        } else {
            $this->code = $code;
        }
        return $this;
    }
    /**
     * Get description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDescription()
    {
        return isset($this->description) ? $this->description : null;
    }
    /**
     * Set description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $description
     * @return \StructType\OutputDistrict
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->description);
        } else {
            $this->description = $description;
        }
        return $this;
    }
    /**
     * Get information value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DistrictInformation[]|null
     */
    public function getInformation()
    {
        return isset($this->information) ? $this->information : null;
    }
    /**
     * This method is responsible for validating the values passed to the setInformation method
     * This method is willingly generated in order to preserve the one-line inline validation within the setInformation method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateInformationForArrayConstraintsFromSetInformation(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $outputDistrictInformationItem) {
            // validation for constraint: itemType
            if (!$outputDistrictInformationItem instanceof \StructType\DistrictInformation) {
                $invalidValues[] = is_object($outputDistrictInformationItem) ? get_class($outputDistrictInformationItem) : sprintf('%s(%s)', gettype($outputDistrictInformationItem), var_export($outputDistrictInformationItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The information property can only contain items of type \StructType\DistrictInformation, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set information value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\DistrictInformation[] $information
     * @return \StructType\OutputDistrict
     */
    public function setInformation(array $information = array())
    {
        // validation for constraint: array
        if ('' !== ($informationArrayErrorMessage = self::validateInformationForArrayConstraintsFromSetInformation($information))) {
            throw new \InvalidArgumentException($informationArrayErrorMessage, __LINE__);
        }
        if (is_null($information) || (is_array($information) && empty($information))) {
            unset($this->information);
        } else {
            $this->information = $information;
        }
        return $this;
    }
    /**
     * Add item to information value
     * @throws \InvalidArgumentException
     * @param \StructType\DistrictInformation $item
     * @return \StructType\OutputDistrict
     */
    public function addToInformation(\StructType\DistrictInformation $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\DistrictInformation) {
            throw new \InvalidArgumentException(sprintf('The information property can only contain items of type \StructType\DistrictInformation, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->information[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\OutputDistrict
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
