<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OutputCity StructType
 * @subpackage Structs
 */
class OutputCity extends AbstractStructBase
{
    /**
     * The code
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $code;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $description;
    /**
     * The information
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\CityInformation[]
     */
    public $information;
    /**
     * Constructor method for OutputCity
     * @uses OutputCity::setCode()
     * @uses OutputCity::setDescription()
     * @uses OutputCity::setInformation()
     * @param int $code
     * @param string $description
     * @param \StructType\CityInformation[] $information
     */
    public function __construct($code = null, $description = null, array $information = array())
    {
        $this
            ->setCode($code)
            ->setDescription($description)
            ->setInformation($information);
    }
    /**
     * Get code value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getCode()
    {
        return isset($this->code) ? $this->code : null;
    }
    /**
     * Set code value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $code
     * @return \StructType\OutputCity
     */
    public function setCode($code = null)
    {
        // validation for constraint: int
        if (!is_null($code) && !(is_int($code) || ctype_digit($code))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($code, true), gettype($code)), __LINE__);
        }
        if (is_null($code) || (is_array($code) && empty($code))) {
            unset($this->code);
        } else {
            $this->code = $code;
        }
        return $this;
    }
    /**
     * Get description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDescription()
    {
        return isset($this->description) ? $this->description : null;
    }
    /**
     * Set description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $description
     * @return \StructType\OutputCity
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->description);
        } else {
            $this->description = $description;
        }
        return $this;
    }
    /**
     * Get information value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\CityInformation[]|null
     */
    public function getInformation()
    {
        return isset($this->information) ? $this->information : null;
    }
    /**
     * This method is responsible for validating the values passed to the setInformation method
     * This method is willingly generated in order to preserve the one-line inline validation within the setInformation method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateInformationForArrayConstraintsFromSetInformation(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $outputCityInformationItem) {
            // validation for constraint: itemType
            if (!$outputCityInformationItem instanceof \StructType\CityInformation) {
                $invalidValues[] = is_object($outputCityInformationItem) ? get_class($outputCityInformationItem) : sprintf('%s(%s)', gettype($outputCityInformationItem), var_export($outputCityInformationItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The information property can only contain items of type \StructType\CityInformation, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set information value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\CityInformation[] $information
     * @return \StructType\OutputCity
     */
    public function setInformation(array $information = array())
    {
        // validation for constraint: array
        if ('' !== ($informationArrayErrorMessage = self::validateInformationForArrayConstraintsFromSetInformation($information))) {
            throw new \InvalidArgumentException($informationArrayErrorMessage, __LINE__);
        }
        if (is_null($information) || (is_array($information) && empty($information))) {
            unset($this->information);
        } else {
            $this->information = $information;
        }
        return $this;
    }
    /**
     * Add item to information value
     * @throws \InvalidArgumentException
     * @param \StructType\CityInformation $item
     * @return \StructType\OutputCity
     */
    public function addToInformation(\StructType\CityInformation $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CityInformation) {
            throw new \InvalidArgumentException(sprintf('The information property can only contain items of type \StructType\CityInformation, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->information[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\OutputCity
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
