<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OutputArrayEn StructType
 * @subpackage Structs
 */
class OutputArrayEn extends AbstractStructBase
{
    /**
     * The itemNo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $itemNo;
    /**
     * The transaction
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $transaction;
    /**
     * The transactionCenter
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $transactionCenter;
    /**
     * The transactionCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $transactionCode;
    /**
     * The transactionDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $transactionDate;
    /**
     * The transactionTime
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $transactionTime;
    /**
     * Constructor method for OutputArrayEn
     * @uses OutputArrayEn::setItemNo()
     * @uses OutputArrayEn::setTransaction()
     * @uses OutputArrayEn::setTransactionCenter()
     * @uses OutputArrayEn::setTransactionCode()
     * @uses OutputArrayEn::setTransactionDate()
     * @uses OutputArrayEn::setTransactionTime()
     * @param int $itemNo
     * @param string $transaction
     * @param string $transactionCenter
     * @param string $transactionCode
     * @param string $transactionDate
     * @param string $transactionTime
     */
    public function __construct($itemNo = null, $transaction = null, $transactionCenter = null, $transactionCode = null, $transactionDate = null, $transactionTime = null)
    {
        $this
            ->setItemNo($itemNo)
            ->setTransaction($transaction)
            ->setTransactionCenter($transactionCenter)
            ->setTransactionCode($transactionCode)
            ->setTransactionDate($transactionDate)
            ->setTransactionTime($transactionTime);
    }
    /**
     * Get itemNo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getItemNo()
    {
        return isset($this->itemNo) ? $this->itemNo : null;
    }
    /**
     * Set itemNo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $itemNo
     * @return \StructType\OutputArrayEn
     */
    public function setItemNo($itemNo = null)
    {
        // validation for constraint: int
        if (!is_null($itemNo) && !(is_int($itemNo) || ctype_digit($itemNo))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($itemNo, true), gettype($itemNo)), __LINE__);
        }
        if (is_null($itemNo) || (is_array($itemNo) && empty($itemNo))) {
            unset($this->itemNo);
        } else {
            $this->itemNo = $itemNo;
        }
        return $this;
    }
    /**
     * Get transaction value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTransaction()
    {
        return isset($this->transaction) ? $this->transaction : null;
    }
    /**
     * Set transaction value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $transaction
     * @return \StructType\OutputArrayEn
     */
    public function setTransaction($transaction = null)
    {
        // validation for constraint: string
        if (!is_null($transaction) && !is_string($transaction)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transaction, true), gettype($transaction)), __LINE__);
        }
        if (is_null($transaction) || (is_array($transaction) && empty($transaction))) {
            unset($this->transaction);
        } else {
            $this->transaction = $transaction;
        }
        return $this;
    }
    /**
     * Get transactionCenter value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTransactionCenter()
    {
        return isset($this->transactionCenter) ? $this->transactionCenter : null;
    }
    /**
     * Set transactionCenter value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $transactionCenter
     * @return \StructType\OutputArrayEn
     */
    public function setTransactionCenter($transactionCenter = null)
    {
        // validation for constraint: string
        if (!is_null($transactionCenter) && !is_string($transactionCenter)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionCenter, true), gettype($transactionCenter)), __LINE__);
        }
        if (is_null($transactionCenter) || (is_array($transactionCenter) && empty($transactionCenter))) {
            unset($this->transactionCenter);
        } else {
            $this->transactionCenter = $transactionCenter;
        }
        return $this;
    }
    /**
     * Get transactionCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTransactionCode()
    {
        return isset($this->transactionCode) ? $this->transactionCode : null;
    }
    /**
     * Set transactionCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $transactionCode
     * @return \StructType\OutputArrayEn
     */
    public function setTransactionCode($transactionCode = null)
    {
        // validation for constraint: string
        if (!is_null($transactionCode) && !is_string($transactionCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionCode, true), gettype($transactionCode)), __LINE__);
        }
        if (is_null($transactionCode) || (is_array($transactionCode) && empty($transactionCode))) {
            unset($this->transactionCode);
        } else {
            $this->transactionCode = $transactionCode;
        }
        return $this;
    }
    /**
     * Get transactionDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTransactionDate()
    {
        return isset($this->transactionDate) ? $this->transactionDate : null;
    }
    /**
     * Set transactionDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $transactionDate
     * @return \StructType\OutputArrayEn
     */
    public function setTransactionDate($transactionDate = null)
    {
        // validation for constraint: string
        if (!is_null($transactionDate) && !is_string($transactionDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionDate, true), gettype($transactionDate)), __LINE__);
        }
        if (is_null($transactionDate) || (is_array($transactionDate) && empty($transactionDate))) {
            unset($this->transactionDate);
        } else {
            $this->transactionDate = $transactionDate;
        }
        return $this;
    }
    /**
     * Get transactionTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTransactionTime()
    {
        return isset($this->transactionTime) ? $this->transactionTime : null;
    }
    /**
     * Set transactionTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $transactionTime
     * @return \StructType\OutputArrayEn
     */
    public function setTransactionTime($transactionTime = null)
    {
        // validation for constraint: string
        if (!is_null($transactionTime) && !is_string($transactionTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionTime, true), gettype($transactionTime)), __LINE__);
        }
        if (is_null($transactionTime) || (is_array($transactionTime) && empty($transactionTime))) {
            unset($this->transactionTime);
        } else {
            $this->transactionTime = $transactionTime;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\OutputArrayEn
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
