<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Shipment ServiceType
 * @subpackage Services
 */
class Shipment extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named shipmentInquiryEn
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ShipmentInquiryEn $parameters
     * @return \StructType\ShipmentInquiryEnResponse|bool
     */
    public function shipmentInquiryEn(\StructType\ShipmentInquiryEn $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->shipmentInquiryEn($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named shipmentInquiry_ReferenceNumberEn
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ShipmentInquiry_ReferenceNumberEn $parameters
     * @return \StructType\ShipmentInquiry_ReferenceNumberEnResponse|bool
     */
    public function shipmentInquiry_ReferenceNumberEn(\StructType\ShipmentInquiry_ReferenceNumberEn $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->shipmentInquiry_ReferenceNumberEn($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\ShipmentInquiryEnResponse|\StructType\ShipmentInquiry_ReferenceNumberEnResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
