<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OutputAllEn StructType
 * @subpackage Structs
 */
class OutputAllEn extends AbstractStructBase
{
    /**
     * The additionalService
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $additionalService;
    /**
     * The addressee
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $addressee;
    /**
     * The array
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\OutputArrayEn[]
     */
    public $array;
    /**
     * The barcodeNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $barcodeNumber;
    /**
     * The destinationCenter
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $destinationCenter;
    /**
     * The gr
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $gr;
    /**
     * The postagePaid
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $postagePaid;
    /**
     * The priceOfCashOnDelivery
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $priceOfCashOnDelivery;
    /**
     * The priceWithInsurance
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $priceWithInsurance;
    /**
     * The recipient
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $recipient;
    /**
     * The resultCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $resultCode;
    /**
     * The resultExplanation
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $resultExplanation;
    /**
     * The sender
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $sender;
    /**
     * The transactionCenter
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $transactionCenter;
    /**
     * The transactionDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $transactionDate;
    /**
     * Constructor method for OutputAllEn
     * @uses OutputAllEn::setAdditionalService()
     * @uses OutputAllEn::setAddressee()
     * @uses OutputAllEn::setArray()
     * @uses OutputAllEn::setBarcodeNumber()
     * @uses OutputAllEn::setDestinationCenter()
     * @uses OutputAllEn::setGr()
     * @uses OutputAllEn::setPostagePaid()
     * @uses OutputAllEn::setPriceOfCashOnDelivery()
     * @uses OutputAllEn::setPriceWithInsurance()
     * @uses OutputAllEn::setRecipient()
     * @uses OutputAllEn::setResultCode()
     * @uses OutputAllEn::setResultExplanation()
     * @uses OutputAllEn::setSender()
     * @uses OutputAllEn::setTransactionCenter()
     * @uses OutputAllEn::setTransactionDate()
     * @param string $additionalService
     * @param string $addressee
     * @param \StructType\OutputArrayEn[] $array
     * @param string $barcodeNumber
     * @param string $destinationCenter
     * @param string $gr
     * @param string $postagePaid
     * @param string $priceOfCashOnDelivery
     * @param string $priceWithInsurance
     * @param string $recipient
     * @param int $resultCode
     * @param string $resultExplanation
     * @param string $sender
     * @param string $transactionCenter
     * @param string $transactionDate
     */
    public function __construct($additionalService = null, $addressee = null, array $array = array(), $barcodeNumber = null, $destinationCenter = null, $gr = null, $postagePaid = null, $priceOfCashOnDelivery = null, $priceWithInsurance = null, $recipient = null, $resultCode = null, $resultExplanation = null, $sender = null, $transactionCenter = null, $transactionDate = null)
    {
        $this
            ->setAdditionalService($additionalService)
            ->setAddressee($addressee)
            ->setArray($array)
            ->setBarcodeNumber($barcodeNumber)
            ->setDestinationCenter($destinationCenter)
            ->setGr($gr)
            ->setPostagePaid($postagePaid)
            ->setPriceOfCashOnDelivery($priceOfCashOnDelivery)
            ->setPriceWithInsurance($priceWithInsurance)
            ->setRecipient($recipient)
            ->setResultCode($resultCode)
            ->setResultExplanation($resultExplanation)
            ->setSender($sender)
            ->setTransactionCenter($transactionCenter)
            ->setTransactionDate($transactionDate);
    }
    /**
     * Get additionalService value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAdditionalService()
    {
        return isset($this->additionalService) ? $this->additionalService : null;
    }
    /**
     * Set additionalService value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $additionalService
     * @return \StructType\OutputAllEn
     */
    public function setAdditionalService($additionalService = null)
    {
        // validation for constraint: string
        if (!is_null($additionalService) && !is_string($additionalService)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($additionalService, true), gettype($additionalService)), __LINE__);
        }
        if (is_null($additionalService) || (is_array($additionalService) && empty($additionalService))) {
            unset($this->additionalService);
        } else {
            $this->additionalService = $additionalService;
        }
        return $this;
    }
    /**
     * Get addressee value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAddressee()
    {
        return isset($this->addressee) ? $this->addressee : null;
    }
    /**
     * Set addressee value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $addressee
     * @return \StructType\OutputAllEn
     */
    public function setAddressee($addressee = null)
    {
        // validation for constraint: string
        if (!is_null($addressee) && !is_string($addressee)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($addressee, true), gettype($addressee)), __LINE__);
        }
        if (is_null($addressee) || (is_array($addressee) && empty($addressee))) {
            unset($this->addressee);
        } else {
            $this->addressee = $addressee;
        }
        return $this;
    }
    /**
     * Get array value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\OutputArrayEn[]|null
     */
    public function getArray()
    {
        return isset($this->array) ? $this->array : null;
    }
    /**
     * This method is responsible for validating the values passed to the setArray method
     * This method is willingly generated in order to preserve the one-line inline validation within the setArray method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateArrayForArrayConstraintsFromSetArray(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $outputAllEnArrayItem) {
            // validation for constraint: itemType
            if (!$outputAllEnArrayItem instanceof \StructType\OutputArrayEn) {
                $invalidValues[] = is_object($outputAllEnArrayItem) ? get_class($outputAllEnArrayItem) : sprintf('%s(%s)', gettype($outputAllEnArrayItem), var_export($outputAllEnArrayItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The array property can only contain items of type \StructType\OutputArrayEn, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set array value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\OutputArrayEn[] $array
     * @return \StructType\OutputAllEn
     */
    public function setArray(array $array = array())
    {
        // validation for constraint: array
        if ('' !== ($arrayArrayErrorMessage = self::validateArrayForArrayConstraintsFromSetArray($array))) {
            throw new \InvalidArgumentException($arrayArrayErrorMessage, __LINE__);
        }
        if (is_null($array) || (is_array($array) && empty($array))) {
            unset($this->array);
        } else {
            $this->array = $array;
        }
        return $this;
    }
    /**
     * Add item to array value
     * @throws \InvalidArgumentException
     * @param \StructType\OutputArrayEn $item
     * @return \StructType\OutputAllEn
     */
    public function addToArray(\StructType\OutputArrayEn $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\OutputArrayEn) {
            throw new \InvalidArgumentException(sprintf('The array property can only contain items of type \StructType\OutputArrayEn, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->array[] = $item;
        return $this;
    }
    /**
     * Get barcodeNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBarcodeNumber()
    {
        return isset($this->barcodeNumber) ? $this->barcodeNumber : null;
    }
    /**
     * Set barcodeNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $barcodeNumber
     * @return \StructType\OutputAllEn
     */
    public function setBarcodeNumber($barcodeNumber = null)
    {
        // validation for constraint: string
        if (!is_null($barcodeNumber) && !is_string($barcodeNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($barcodeNumber, true), gettype($barcodeNumber)), __LINE__);
        }
        if (is_null($barcodeNumber) || (is_array($barcodeNumber) && empty($barcodeNumber))) {
            unset($this->barcodeNumber);
        } else {
            $this->barcodeNumber = $barcodeNumber;
        }
        return $this;
    }
    /**
     * Get destinationCenter value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDestinationCenter()
    {
        return isset($this->destinationCenter) ? $this->destinationCenter : null;
    }
    /**
     * Set destinationCenter value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $destinationCenter
     * @return \StructType\OutputAllEn
     */
    public function setDestinationCenter($destinationCenter = null)
    {
        // validation for constraint: string
        if (!is_null($destinationCenter) && !is_string($destinationCenter)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($destinationCenter, true), gettype($destinationCenter)), __LINE__);
        }
        if (is_null($destinationCenter) || (is_array($destinationCenter) && empty($destinationCenter))) {
            unset($this->destinationCenter);
        } else {
            $this->destinationCenter = $destinationCenter;
        }
        return $this;
    }
    /**
     * Get gr value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGr()
    {
        return isset($this->gr) ? $this->gr : null;
    }
    /**
     * Set gr value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $gr
     * @return \StructType\OutputAllEn
     */
    public function setGr($gr = null)
    {
        // validation for constraint: string
        if (!is_null($gr) && !is_string($gr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gr, true), gettype($gr)), __LINE__);
        }
        if (is_null($gr) || (is_array($gr) && empty($gr))) {
            unset($this->gr);
        } else {
            $this->gr = $gr;
        }
        return $this;
    }
    /**
     * Get postagePaid value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPostagePaid()
    {
        return isset($this->postagePaid) ? $this->postagePaid : null;
    }
    /**
     * Set postagePaid value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $postagePaid
     * @return \StructType\OutputAllEn
     */
    public function setPostagePaid($postagePaid = null)
    {
        // validation for constraint: string
        if (!is_null($postagePaid) && !is_string($postagePaid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($postagePaid, true), gettype($postagePaid)), __LINE__);
        }
        if (is_null($postagePaid) || (is_array($postagePaid) && empty($postagePaid))) {
            unset($this->postagePaid);
        } else {
            $this->postagePaid = $postagePaid;
        }
        return $this;
    }
    /**
     * Get priceOfCashOnDelivery value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPriceOfCashOnDelivery()
    {
        return isset($this->priceOfCashOnDelivery) ? $this->priceOfCashOnDelivery : null;
    }
    /**
     * Set priceOfCashOnDelivery value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $priceOfCashOnDelivery
     * @return \StructType\OutputAllEn
     */
    public function setPriceOfCashOnDelivery($priceOfCashOnDelivery = null)
    {
        // validation for constraint: string
        if (!is_null($priceOfCashOnDelivery) && !is_string($priceOfCashOnDelivery)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($priceOfCashOnDelivery, true), gettype($priceOfCashOnDelivery)), __LINE__);
        }
        if (is_null($priceOfCashOnDelivery) || (is_array($priceOfCashOnDelivery) && empty($priceOfCashOnDelivery))) {
            unset($this->priceOfCashOnDelivery);
        } else {
            $this->priceOfCashOnDelivery = $priceOfCashOnDelivery;
        }
        return $this;
    }
    /**
     * Get priceWithInsurance value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPriceWithInsurance()
    {
        return isset($this->priceWithInsurance) ? $this->priceWithInsurance : null;
    }
    /**
     * Set priceWithInsurance value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $priceWithInsurance
     * @return \StructType\OutputAllEn
     */
    public function setPriceWithInsurance($priceWithInsurance = null)
    {
        // validation for constraint: string
        if (!is_null($priceWithInsurance) && !is_string($priceWithInsurance)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($priceWithInsurance, true), gettype($priceWithInsurance)), __LINE__);
        }
        if (is_null($priceWithInsurance) || (is_array($priceWithInsurance) && empty($priceWithInsurance))) {
            unset($this->priceWithInsurance);
        } else {
            $this->priceWithInsurance = $priceWithInsurance;
        }
        return $this;
    }
    /**
     * Get recipient value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRecipient()
    {
        return isset($this->recipient) ? $this->recipient : null;
    }
    /**
     * Set recipient value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $recipient
     * @return \StructType\OutputAllEn
     */
    public function setRecipient($recipient = null)
    {
        // validation for constraint: string
        if (!is_null($recipient) && !is_string($recipient)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($recipient, true), gettype($recipient)), __LINE__);
        }
        if (is_null($recipient) || (is_array($recipient) && empty($recipient))) {
            unset($this->recipient);
        } else {
            $this->recipient = $recipient;
        }
        return $this;
    }
    /**
     * Get resultCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getResultCode()
    {
        return isset($this->resultCode) ? $this->resultCode : null;
    }
    /**
     * Set resultCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $resultCode
     * @return \StructType\OutputAllEn
     */
    public function setResultCode($resultCode = null)
    {
        // validation for constraint: int
        if (!is_null($resultCode) && !(is_int($resultCode) || ctype_digit($resultCode))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($resultCode, true), gettype($resultCode)), __LINE__);
        }
        if (is_null($resultCode) || (is_array($resultCode) && empty($resultCode))) {
            unset($this->resultCode);
        } else {
            $this->resultCode = $resultCode;
        }
        return $this;
    }
    /**
     * Get resultExplanation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getResultExplanation()
    {
        return isset($this->resultExplanation) ? $this->resultExplanation : null;
    }
    /**
     * Set resultExplanation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $resultExplanation
     * @return \StructType\OutputAllEn
     */
    public function setResultExplanation($resultExplanation = null)
    {
        // validation for constraint: string
        if (!is_null($resultExplanation) && !is_string($resultExplanation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($resultExplanation, true), gettype($resultExplanation)), __LINE__);
        }
        if (is_null($resultExplanation) || (is_array($resultExplanation) && empty($resultExplanation))) {
            unset($this->resultExplanation);
        } else {
            $this->resultExplanation = $resultExplanation;
        }
        return $this;
    }
    /**
     * Get sender value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSender()
    {
        return isset($this->sender) ? $this->sender : null;
    }
    /**
     * Set sender value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sender
     * @return \StructType\OutputAllEn
     */
    public function setSender($sender = null)
    {
        // validation for constraint: string
        if (!is_null($sender) && !is_string($sender)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sender, true), gettype($sender)), __LINE__);
        }
        if (is_null($sender) || (is_array($sender) && empty($sender))) {
            unset($this->sender);
        } else {
            $this->sender = $sender;
        }
        return $this;
    }
    /**
     * Get transactionCenter value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTransactionCenter()
    {
        return isset($this->transactionCenter) ? $this->transactionCenter : null;
    }
    /**
     * Set transactionCenter value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $transactionCenter
     * @return \StructType\OutputAllEn
     */
    public function setTransactionCenter($transactionCenter = null)
    {
        // validation for constraint: string
        if (!is_null($transactionCenter) && !is_string($transactionCenter)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionCenter, true), gettype($transactionCenter)), __LINE__);
        }
        if (is_null($transactionCenter) || (is_array($transactionCenter) && empty($transactionCenter))) {
            unset($this->transactionCenter);
        } else {
            $this->transactionCenter = $transactionCenter;
        }
        return $this;
    }
    /**
     * Get transactionDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTransactionDate()
    {
        return isset($this->transactionDate) ? $this->transactionDate : null;
    }
    /**
     * Set transactionDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $transactionDate
     * @return \StructType\OutputAllEn
     */
    public function setTransactionDate($transactionDate = null)
    {
        // validation for constraint: string
        if (!is_null($transactionDate) && !is_string($transactionDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionDate, true), gettype($transactionDate)), __LINE__);
        }
        if (is_null($transactionDate) || (is_array($transactionDate) && empty($transactionDate))) {
            unset($this->transactionDate);
        } else {
            $this->transactionDate = $transactionDate;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\OutputAllEn
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
