<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the fist needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientbase class each generated ServiceType class extends this class
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://pttws.ptt.gov.tr/GonderiTakipV2/services/Sorgu?wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc....
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://pttws.ptt.gov.tr/GonderiTakipV2/services/Sorgu?wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => ClassMap::get(),
);
/**
 * Samples for Get ServiceType
 */
$get = new \ServiceType\Get($options);
/**
 * Sample call for getAllDropPointInfo operation/method
 */
if ($get->getAllDropPointInfo(new \StructType\GetAllDropPointInfo()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getDistrict operation/method
 */
if ($get->getDistrict(new \StructType\GetDistrict()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getDropPointInfo operation/method
 */
if ($get->getDropPointInfo(new \StructType\GetDropPointInfo()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getCity operation/method
 */
if ($get->getCity(new \StructType\GetCity()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Samples for Gonderi ServiceType
 */
$gonderi = new \ServiceType\Gonderi($options);
/**
 * Sample call for gonderiSorgu2 operation/method
 */
if ($gonderi->gonderiSorgu2(new \StructType\GonderiSorgu2()) !== false) {
    print_r($gonderi->getResult());
} else {
    print_r($gonderi->getLastError());
}
/**
 * Sample call for gonderiSorgu_referansNo operation/method
 */
if ($gonderi->gonderiSorgu_referansNo(new \StructType\GonderiSorgu_referansNo()) !== false) {
    print_r($gonderi->getResult());
} else {
    print_r($gonderi->getLastError());
}
/**
 * Sample call for gonderiSorgu operation/method
 */
if ($gonderi->gonderiSorgu(new \StructType\GonderiSorgu()) !== false) {
    print_r($gonderi->getResult());
} else {
    print_r($gonderi->getLastError());
}
/**
 * Samples for Shipment ServiceType
 */
$shipment = new \ServiceType\Shipment($options);
/**
 * Sample call for shipmentInquiryEn operation/method
 */
if ($shipment->shipmentInquiryEn(new \StructType\ShipmentInquiryEn()) !== false) {
    print_r($shipment->getResult());
} else {
    print_r($shipment->getLastError());
}
/**
 * Sample call for shipmentInquiry_ReferenceNumberEn operation/method
 */
if ($shipment->shipmentInquiry_ReferenceNumberEn(new \StructType\ShipmentInquiry_ReferenceNumberEn()) !== false) {
    print_r($shipment->getResult());
} else {
    print_r($shipment->getLastError());
}
/**
 * Samples for Referans ServiceType
 */
$referans = new \ServiceType\Referans($options);
/**
 * Sample call for referansSorgu operation/method
 */
if ($referans->referansSorgu(new \StructType\ReferansSorgu()) !== false) {
    print_r($referans->getResult());
} else {
    print_r($referans->getLastError());
}
