<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Gonderi ServiceType
 * @subpackage Services
 */
class Gonderi extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named gonderiSorgu2
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GonderiSorgu2 $parameters
     * @return \StructType\GonderiSorgu2Response|bool
     */
    public function gonderiSorgu2(\StructType\GonderiSorgu2 $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->gonderiSorgu2($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named gonderiSorgu_referansNo
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GonderiSorgu_referansNo $parameters
     * @return \StructType\GonderiSorgu_referansNoResponse|bool
     */
    public function gonderiSorgu_referansNo(\StructType\GonderiSorgu_referansNo $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->gonderiSorgu_referansNo($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named gonderiSorgu
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GonderiSorgu $parameters
     * @return \StructType\GonderiSorguResponse|bool
     */
    public function gonderiSorgu(\StructType\GonderiSorgu $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->gonderiSorgu($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\GonderiSorgu2Response|\StructType\GonderiSorguResponse|\StructType\GonderiSorgu_referansNoResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
