<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DistrictInformation StructType
 * @subpackage Structs
 */
class DistrictInformation extends AbstractStructBase
{
    /**
     * The city_code
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $city_code;
    /**
     * The city_name
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $city_name;
    /**
     * The province_code
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $province_code;
    /**
     * Constructor method for DistrictInformation
     * @uses DistrictInformation::setCity_code()
     * @uses DistrictInformation::setCity_name()
     * @uses DistrictInformation::setProvince_code()
     * @param int $city_code
     * @param string $city_name
     * @param int $province_code
     */
    public function __construct($city_code = null, $city_name = null, $province_code = null)
    {
        $this
            ->setCity_code($city_code)
            ->setCity_name($city_name)
            ->setProvince_code($province_code);
    }
    /**
     * Get city_code value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getCity_code()
    {
        return isset($this->city_code) ? $this->city_code : null;
    }
    /**
     * Set city_code value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $city_code
     * @return \StructType\DistrictInformation
     */
    public function setCity_code($city_code = null)
    {
        // validation for constraint: int
        if (!is_null($city_code) && !(is_int($city_code) || ctype_digit($city_code))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($city_code, true), gettype($city_code)), __LINE__);
        }
        if (is_null($city_code) || (is_array($city_code) && empty($city_code))) {
            unset($this->city_code);
        } else {
            $this->city_code = $city_code;
        }
        return $this;
    }
    /**
     * Get city_name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCity_name()
    {
        return isset($this->city_name) ? $this->city_name : null;
    }
    /**
     * Set city_name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $city_name
     * @return \StructType\DistrictInformation
     */
    public function setCity_name($city_name = null)
    {
        // validation for constraint: string
        if (!is_null($city_name) && !is_string($city_name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($city_name, true), gettype($city_name)), __LINE__);
        }
        if (is_null($city_name) || (is_array($city_name) && empty($city_name))) {
            unset($this->city_name);
        } else {
            $this->city_name = $city_name;
        }
        return $this;
    }
    /**
     * Get province_code value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getProvince_code()
    {
        return isset($this->province_code) ? $this->province_code : null;
    }
    /**
     * Set province_code value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $province_code
     * @return \StructType\DistrictInformation
     */
    public function setProvince_code($province_code = null)
    {
        // validation for constraint: int
        if (!is_null($province_code) && !(is_int($province_code) || ctype_digit($province_code))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($province_code, true), gettype($province_code)), __LINE__);
        }
        if (is_null($province_code) || (is_array($province_code) && empty($province_code))) {
            unset($this->province_code);
        } else {
            $this->province_code = $province_code;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DistrictInformation
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
