<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Kargomat ServiceType
 * @subpackage Services
 */
class Kargomat extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named kargomatListesi
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\KargomatListesi $parameters
     * @return \StructType\KargomatListesiResponse|bool
     */
    public function kargomatListesi(\StructType\KargomatListesi $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->kargomatListesi($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\KargomatListesiResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
