<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Ek ServiceType
 * @subpackage Services
 */
class Ek extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named ekHizmetSorgula
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EkHizmetSorgula $parameters
     * @return \StructType\EkHizmetSorgulaResponse|bool
     */
    public function ekHizmetSorgula(\StructType\EkHizmetSorgula $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ekHizmetSorgula($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\EkHizmetSorgulaResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
