<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Ulke ServiceType
 * @subpackage Services
 */
class Ulke extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named ulkeKodGrupSorgulama
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UlkeKodGrupSorgulama $parameters
     * @return \StructType\UlkeKodGrupSorgulamaResponse|bool
     */
    public function ulkeKodGrupSorgulama(\StructType\UlkeKodGrupSorgulama $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ulkeKodGrupSorgulama($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\UlkeKodGrupSorgulamaResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
