<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Ucret ServiceType
 * @subpackage Services
 */
class Ucret extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named ucretKargo2
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UcretKargo2 $parameters
     * @return \StructType\UcretKargo2Response|bool
     */
    public function ucretKargo2(\StructType\UcretKargo2 $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ucretKargo2($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\UcretKargo2Response
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
