<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Posta ServiceType
 * @subpackage Services
 */
class Posta extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named postaUcret
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\PostaUcret $parameters
     * @return \StructType\PostaUcretResponse|bool
     */
    public function postaUcret(\StructType\PostaUcret $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->postaUcret($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\PostaUcretResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
