<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Ilce ServiceType
 * @subpackage Services
 */
class Ilce extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named ilceSorgula
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\IlceSorgula $parameters
     * @return \StructType\IlceSorgulaResponse|bool
     */
    public function ilceSorgula(\StructType\IlceSorgula $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ilceSorgula($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\IlceSorgulaResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
