<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Gonderi ServiceType
 * @subpackage Services
 */
class Gonderi extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named gonderiDurumAciklamaSorgula
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GonderiDurumAciklamaSorgula $parameters
     * @return \StructType\GonderiDurumAciklamaSorgulaResponse|bool
     */
    public function gonderiDurumAciklamaSorgula(\StructType\GonderiDurumAciklamaSorgula $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->gonderiDurumAciklamaSorgula($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\GonderiDurumAciklamaSorgulaResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
