<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the fist needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientbase class each generated ServiceType class extends this class
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://pttws.ptt.gov.tr/PttBilgi/services/Sorgu?wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc....
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://pttws.ptt.gov.tr/PttBilgi/services/Sorgu?wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => ClassMap::get(),
);
/**
 * Samples for Kargo ServiceType
 */
$kargo = new \ServiceType\Kargo($options);
/**
 * Sample call for kargoUcret operation/method
 */
if ($kargo->kargoUcret(new \StructType\KargoUcret()) !== false) {
    print_r($kargo->getResult());
} else {
    print_r($kargo->getLastError());
}
/**
 * Samples for Telgraf ServiceType
 */
$telgraf = new \ServiceType\Telgraf($options);
/**
 * Sample call for telgrafUcret operation/method
 */
if ($telgraf->telgrafUcret(new \StructType\TelgrafUcret()) !== false) {
    print_r($telgraf->getResult());
} else {
    print_r($telgraf->getLastError());
}
/**
 * Samples for Gonderi ServiceType
 */
$gonderi = new \ServiceType\Gonderi($options);
/**
 * Sample call for gonderiDurumAciklamaSorgula operation/method
 */
if ($gonderi->gonderiDurumAciklamaSorgula(new \StructType\GonderiDurumAciklamaSorgula()) !== false) {
    print_r($gonderi->getResult());
} else {
    print_r($gonderi->getLastError());
}
/**
 * Samples for Yurt ServiceType
 */
$yurt = new \ServiceType\Yurt($options);
/**
 * Sample call for yurtDisiFaxUcret operation/method
 */
if ($yurt->yurtDisiFaxUcret(new \StructType\YurtDisiFaxUcret()) !== false) {
    print_r($yurt->getResult());
} else {
    print_r($yurt->getLastError());
}
/**
 * Samples for Ucret ServiceType
 */
$ucret = new \ServiceType\Ucret($options);
/**
 * Sample call for ucretKargo2 operation/method
 */
if ($ucret->ucretKargo2(new \StructType\UcretKargo2()) !== false) {
    print_r($ucret->getResult());
} else {
    print_r($ucret->getLastError());
}
/**
 * Samples for Kargomat ServiceType
 */
$kargomat = new \ServiceType\Kargomat($options);
/**
 * Sample call for kargomatListesi operation/method
 */
if ($kargomat->kargomatListesi(new \StructType\KargomatListesi()) !== false) {
    print_r($kargomat->getResult());
} else {
    print_r($kargomat->getLastError());
}
/**
 * Samples for Posta ServiceType
 */
$posta = new \ServiceType\Posta($options);
/**
 * Sample call for postaUcret operation/method
 */
if ($posta->postaUcret(new \StructType\PostaUcret()) !== false) {
    print_r($posta->getResult());
} else {
    print_r($posta->getLastError());
}
/**
 * Samples for Ilce ServiceType
 */
$ilce = new \ServiceType\Ilce($options);
/**
 * Sample call for ilceSorgula operation/method
 */
if ($ilce->ilceSorgula(new \StructType\IlceSorgula()) !== false) {
    print_r($ilce->getResult());
} else {
    print_r($ilce->getLastError());
}
/**
 * Samples for Ulke ServiceType
 */
$ulke = new \ServiceType\Ulke($options);
/**
 * Sample call for ulkeKodGrupSorgulama operation/method
 */
if ($ulke->ulkeKodGrupSorgulama(new \StructType\UlkeKodGrupSorgulama()) !== false) {
    print_r($ulke->getResult());
} else {
    print_r($ulke->getLastError());
}
/**
 * Samples for Ek ServiceType
 */
$ek = new \ServiceType\Ek($options);
/**
 * Sample call for ekHizmetSorgula operation/method
 */
if ($ek->ekHizmetSorgula(new \StructType\EkHizmetSorgula()) !== false) {
    print_r($ek->getResult());
} else {
    print_r($ek->getLastError());
}
