<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Yurt ServiceType
 * @subpackage Services
 */
class Yurt extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named yurtDisiFaxUcret
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\YurtDisiFaxUcret $parameters
     * @return \StructType\YurtDisiFaxUcretResponse|bool
     */
    public function yurtDisiFaxUcret(\StructType\YurtDisiFaxUcret $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->yurtDisiFaxUcret($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\YurtDisiFaxUcretResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
