<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Output2 StructType
 * @subpackage Structs
 */
class Output2 extends AbstractStructBase
{
    /**
     * The aciklama
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $aciklama;
    /**
     * The dongu
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\OutputDongu2[]
     */
    public $dongu;
    /**
     * The hataKodu
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $hataKodu;
    /**
     * Constructor method for Output2
     * @uses Output2::setAciklama()
     * @uses Output2::setDongu()
     * @uses Output2::setHataKodu()
     * @param string $aciklama
     * @param \StructType\OutputDongu2[] $dongu
     * @param int $hataKodu
     */
    public function __construct($aciklama = null, array $dongu = array(), $hataKodu = null)
    {
        $this
            ->setAciklama($aciklama)
            ->setDongu($dongu)
            ->setHataKodu($hataKodu);
    }
    /**
     * Get aciklama value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAciklama()
    {
        return isset($this->aciklama) ? $this->aciklama : null;
    }
    /**
     * Set aciklama value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $aciklama
     * @return \StructType\Output2
     */
    public function setAciklama($aciklama = null)
    {
        // validation for constraint: string
        if (!is_null($aciklama) && !is_string($aciklama)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aciklama, true), gettype($aciklama)), __LINE__);
        }
        if (is_null($aciklama) || (is_array($aciklama) && empty($aciklama))) {
            unset($this->aciklama);
        } else {
            $this->aciklama = $aciklama;
        }
        return $this;
    }
    /**
     * Get dongu value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\OutputDongu2[]|null
     */
    public function getDongu()
    {
        return isset($this->dongu) ? $this->dongu : null;
    }
    /**
     * This method is responsible for validating the values passed to the setDongu method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDongu method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDonguForArrayConstraintsFromSetDongu(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $output2DonguItem) {
            // validation for constraint: itemType
            if (!$output2DonguItem instanceof \StructType\OutputDongu2) {
                $invalidValues[] = is_object($output2DonguItem) ? get_class($output2DonguItem) : sprintf('%s(%s)', gettype($output2DonguItem), var_export($output2DonguItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The dongu property can only contain items of type \StructType\OutputDongu2, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set dongu value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\OutputDongu2[] $dongu
     * @return \StructType\Output2
     */
    public function setDongu(array $dongu = array())
    {
        // validation for constraint: array
        if ('' !== ($donguArrayErrorMessage = self::validateDonguForArrayConstraintsFromSetDongu($dongu))) {
            throw new \InvalidArgumentException($donguArrayErrorMessage, __LINE__);
        }
        if (is_null($dongu) || (is_array($dongu) && empty($dongu))) {
            unset($this->dongu);
        } else {
            $this->dongu = $dongu;
        }
        return $this;
    }
    /**
     * Add item to dongu value
     * @throws \InvalidArgumentException
     * @param \StructType\OutputDongu2 $item
     * @return \StructType\Output2
     */
    public function addToDongu(\StructType\OutputDongu2 $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\OutputDongu2) {
            throw new \InvalidArgumentException(sprintf('The dongu property can only contain items of type \StructType\OutputDongu2, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->dongu[] = $item;
        return $this;
    }
    /**
     * Get hataKodu value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getHataKodu()
    {
        return isset($this->hataKodu) ? $this->hataKodu : null;
    }
    /**
     * Set hataKodu value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $hataKodu
     * @return \StructType\Output2
     */
    public function setHataKodu($hataKodu = null)
    {
        // validation for constraint: int
        if (!is_null($hataKodu) && !(is_int($hataKodu) || ctype_digit($hataKodu))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($hataKodu, true), gettype($hataKodu)), __LINE__);
        }
        if (is_null($hataKodu) || (is_array($hataKodu) && empty($hataKodu))) {
            unset($this->hataKodu);
        } else {
            $this->hataKodu = $hataKodu;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Output2
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
