<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Referans ServiceType
 * @subpackage Services
 */
class Referans extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named referansVeriSil
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ReferansVeriSil $parameters
     * @return \StructType\ReferansVeriSilResponse|bool
     */
    public function referansVeriSil(\StructType\ReferansVeriSil $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->referansVeriSil($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\ReferansVeriSilResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
