<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Barkod ServiceType
 * @subpackage Services
 */
class Barkod extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named barkodVeriSil
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\BarkodVeriSil $parameters
     * @return \StructType\BarkodVeriSilResponse|bool
     */
    public function barkodVeriSil(\StructType\BarkodVeriSil $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->barkodVeriSil($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\BarkodVeriSilResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
