<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Kabul ServiceType
 * @subpackage Services
 */
class Kabul extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named kabulEkle2
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\KabulEkle2 $parameters
     * @return \StructType\KabulEkle2Response|bool
     */
    public function kabulEkle2(\StructType\KabulEkle2 $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->kabulEkle2($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named kabulEkleParcaliBarkod
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\KabulEkleParcaliBarkod $parameters
     * @return \StructType\KabulEkleParcaliBarkodResponse|bool
     */
    public function kabulEkleParcaliBarkod(\StructType\KabulEkleParcaliBarkod $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->kabulEkleParcaliBarkod($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named kabulEkle
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\KabulEkle $parameters
     * @return \StructType\KabulEkleResponse|bool
     */
    public function kabulEkle(\StructType\KabulEkle $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->kabulEkle($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\KabulEkle2Response|\StructType\KabulEkleParcaliBarkodResponse|\StructType\KabulEkleResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
