<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the fist needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientbase class each generated ServiceType class extends this class
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://pttws.ptt.gov.tr/PttVeriYukleme/services/Sorgu?wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc....
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://pttws.ptt.gov.tr/PttVeriYukleme/services/Sorgu?wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => ClassMap::get(),
);
/**
 * Samples for Kabul ServiceType
 */
$kabul = new \ServiceType\Kabul($options);
/**
 * Sample call for kabulEkle2 operation/method
 */
if ($kabul->kabulEkle2(new \StructType\KabulEkle2()) !== false) {
    print_r($kabul->getResult());
} else {
    print_r($kabul->getLastError());
}
/**
 * Sample call for kabulEkleParcaliBarkod operation/method
 */
if ($kabul->kabulEkleParcaliBarkod(new \StructType\KabulEkleParcaliBarkod()) !== false) {
    print_r($kabul->getResult());
} else {
    print_r($kabul->getLastError());
}
/**
 * Sample call for kabulEkle operation/method
 */
if ($kabul->kabulEkle(new \StructType\KabulEkle()) !== false) {
    print_r($kabul->getResult());
} else {
    print_r($kabul->getLastError());
}
/**
 * Samples for Siparis ServiceType
 */
$siparis = new \ServiceType\Siparis($options);
/**
 * Sample call for siparisIstekEkle2 operation/method
 */
if ($siparis->siparisIstekEkle2(new \StructType\SiparisIstekEkle2()) !== false) {
    print_r($siparis->getResult());
} else {
    print_r($siparis->getLastError());
}
/**
 * Sample call for siparisIstekEkle operation/method
 */
if ($siparis->siparisIstekEkle(new \StructType\SiparisIstekEkle()) !== false) {
    print_r($siparis->getResult());
} else {
    print_r($siparis->getLastError());
}
/**
 * Samples for Referans ServiceType
 */
$referans = new \ServiceType\Referans($options);
/**
 * Sample call for referansVeriSil operation/method
 */
if ($referans->referansVeriSil(new \StructType\ReferansVeriSil()) !== false) {
    print_r($referans->getResult());
} else {
    print_r($referans->getLastError());
}
/**
 * Samples for Barkod ServiceType
 */
$barkod = new \ServiceType\Barkod($options);
/**
 * Sample call for barkodVeriSil operation/method
 */
if ($barkod->barkodVeriSil(new \StructType\BarkodVeriSil()) !== false) {
    print_r($barkod->getResult());
} else {
    print_r($barkod->getLastError());
}
