<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InputDelete StructType
 * @subpackage Structs
 */
class InputDelete extends AbstractStructBase
{
    /**
     * The barcode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $barcode;
    /**
     * The dosyaAdi
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $dosyaAdi;
    /**
     * The musteriId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $musteriId;
    /**
     * The sifre
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $sifre;
    /**
     * Constructor method for InputDelete
     * @uses InputDelete::setBarcode()
     * @uses InputDelete::setDosyaAdi()
     * @uses InputDelete::setMusteriId()
     * @uses InputDelete::setSifre()
     * @param string $barcode
     * @param string $dosyaAdi
     * @param int $musteriId
     * @param string $sifre
     */
    public function __construct($barcode = null, $dosyaAdi = null, $musteriId = null, $sifre = null)
    {
        $this
            ->setBarcode($barcode)
            ->setDosyaAdi($dosyaAdi)
            ->setMusteriId($musteriId)
            ->setSifre($sifre);
    }
    /**
     * Get barcode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBarcode()
    {
        return isset($this->barcode) ? $this->barcode : null;
    }
    /**
     * Set barcode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $barcode
     * @return \StructType\InputDelete
     */
    public function setBarcode($barcode = null)
    {
        // validation for constraint: string
        if (!is_null($barcode) && !is_string($barcode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($barcode, true), gettype($barcode)), __LINE__);
        }
        if (is_null($barcode) || (is_array($barcode) && empty($barcode))) {
            unset($this->barcode);
        } else {
            $this->barcode = $barcode;
        }
        return $this;
    }
    /**
     * Get dosyaAdi value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDosyaAdi()
    {
        return isset($this->dosyaAdi) ? $this->dosyaAdi : null;
    }
    /**
     * Set dosyaAdi value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dosyaAdi
     * @return \StructType\InputDelete
     */
    public function setDosyaAdi($dosyaAdi = null)
    {
        // validation for constraint: string
        if (!is_null($dosyaAdi) && !is_string($dosyaAdi)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dosyaAdi, true), gettype($dosyaAdi)), __LINE__);
        }
        if (is_null($dosyaAdi) || (is_array($dosyaAdi) && empty($dosyaAdi))) {
            unset($this->dosyaAdi);
        } else {
            $this->dosyaAdi = $dosyaAdi;
        }
        return $this;
    }
    /**
     * Get musteriId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getMusteriId()
    {
        return isset($this->musteriId) ? $this->musteriId : null;
    }
    /**
     * Set musteriId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $musteriId
     * @return \StructType\InputDelete
     */
    public function setMusteriId($musteriId = null)
    {
        // validation for constraint: int
        if (!is_null($musteriId) && !(is_int($musteriId) || ctype_digit($musteriId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($musteriId, true), gettype($musteriId)), __LINE__);
        }
        if (is_null($musteriId) || (is_array($musteriId) && empty($musteriId))) {
            unset($this->musteriId);
        } else {
            $this->musteriId = $musteriId;
        }
        return $this;
    }
    /**
     * Get sifre value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSifre()
    {
        return isset($this->sifre) ? $this->sifre : null;
    }
    /**
     * Set sifre value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sifre
     * @return \StructType\InputDelete
     */
    public function setSifre($sifre = null)
    {
        // validation for constraint: string
        if (!is_null($sifre) && !is_string($sifre)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sifre, true), gettype($sifre)), __LINE__);
        }
        if (is_null($sifre) || (is_array($sifre) && empty($sifre))) {
            unset($this->sifre);
        } else {
            $this->sifre = $sifre;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\InputDelete
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
