<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProductOffer StructType
 * @subpackage Structs
 */
class ProductOffer extends AbstractStructBase
{
    /**
     * The basicPrice
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $basicPrice;
    /**
     * The calcType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $calcType;
    /**
     * The currency
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $currency;
    /**
     * The product
     * @var string
     */
    public $product;
    /**
     * The productName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $productName;
    /**
     * The region
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $region;
    /**
     * The regionName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $regionName;
    /**
     * The tariff
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $tariff;
    /**
     * The tariffDescription
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $tariffDescription;
    /**
     * The tariffGroupCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $tariffGroupCode;
    /**
     * The tariffGroupName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $tariffGroupName;
    /**
     * The tariffGroupDescription
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $tariffGroupDescription;
    /**
     * The usageInfo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $usageInfo;
    /**
     * The prices
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\PriceInfo
     */
    public $prices;
    /**
     * Constructor method for ProductOffer
     * @uses ProductOffer::setBasicPrice()
     * @uses ProductOffer::setCalcType()
     * @uses ProductOffer::setCurrency()
     * @uses ProductOffer::setProduct()
     * @uses ProductOffer::setProductName()
     * @uses ProductOffer::setRegion()
     * @uses ProductOffer::setRegionName()
     * @uses ProductOffer::setTariff()
     * @uses ProductOffer::setTariffDescription()
     * @uses ProductOffer::setTariffGroupCode()
     * @uses ProductOffer::setTariffGroupName()
     * @uses ProductOffer::setTariffGroupDescription()
     * @uses ProductOffer::setUsageInfo()
     * @uses ProductOffer::setPrices()
     * @param float $basicPrice
     * @param string $calcType
     * @param string $currency
     * @param string $product
     * @param string $productName
     * @param string $region
     * @param string $regionName
     * @param string $tariff
     * @param string $tariffDescription
     * @param string $tariffGroupCode
     * @param string $tariffGroupName
     * @param string $tariffGroupDescription
     * @param string $usageInfo
     * @param \StructType\PriceInfo $prices
     */
    public function __construct($basicPrice = null, $calcType = null, $currency = null, $product = null, $productName = null, $region = null, $regionName = null, $tariff = null, $tariffDescription = null, $tariffGroupCode = null, $tariffGroupName = null, $tariffGroupDescription = null, $usageInfo = null, \StructType\PriceInfo $prices = null)
    {
        $this
            ->setBasicPrice($basicPrice)
            ->setCalcType($calcType)
            ->setCurrency($currency)
            ->setProduct($product)
            ->setProductName($productName)
            ->setRegion($region)
            ->setRegionName($regionName)
            ->setTariff($tariff)
            ->setTariffDescription($tariffDescription)
            ->setTariffGroupCode($tariffGroupCode)
            ->setTariffGroupName($tariffGroupName)
            ->setTariffGroupDescription($tariffGroupDescription)
            ->setUsageInfo($usageInfo)
            ->setPrices($prices);
    }
    /**
     * Get basicPrice value
     * @return float|null
     */
    public function getBasicPrice()
    {
        return $this->basicPrice;
    }
    /**
     * Set basicPrice value
     * @param float $basicPrice
     * @return \StructType\ProductOffer
     */
    public function setBasicPrice($basicPrice = null)
    {
        // validation for constraint: float
        if (!is_null($basicPrice) && !(is_float($basicPrice) || is_numeric($basicPrice))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($basicPrice, true), gettype($basicPrice)), __LINE__);
        }
        $this->basicPrice = $basicPrice;
        return $this;
    }
    /**
     * Get calcType value
     * @return string|null
     */
    public function getCalcType()
    {
        return $this->calcType;
    }
    /**
     * Set calcType value
     * @param string $calcType
     * @return \StructType\ProductOffer
     */
    public function setCalcType($calcType = null)
    {
        // validation for constraint: string
        if (!is_null($calcType) && !is_string($calcType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($calcType, true), gettype($calcType)), __LINE__);
        }
        $this->calcType = $calcType;
        return $this;
    }
    /**
     * Get currency value
     * @return string|null
     */
    public function getCurrency()
    {
        return $this->currency;
    }
    /**
     * Set currency value
     * @param string $currency
     * @return \StructType\ProductOffer
     */
    public function setCurrency($currency = null)
    {
        // validation for constraint: string
        if (!is_null($currency) && !is_string($currency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currency, true), gettype($currency)), __LINE__);
        }
        $this->currency = $currency;
        return $this;
    }
    /**
     * Get product value
     * @return string|null
     */
    public function getProduct()
    {
        return $this->product;
    }
    /**
     * Set product value
     * @param string $product
     * @return \StructType\ProductOffer
     */
    public function setProduct($product = null)
    {
        // validation for constraint: string
        if (!is_null($product) && !is_string($product)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($product, true), gettype($product)), __LINE__);
        }
        $this->product = $product;
        return $this;
    }
    /**
     * Get productName value
     * @return string|null
     */
    public function getProductName()
    {
        return $this->productName;
    }
    /**
     * Set productName value
     * @param string $productName
     * @return \StructType\ProductOffer
     */
    public function setProductName($productName = null)
    {
        // validation for constraint: string
        if (!is_null($productName) && !is_string($productName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($productName, true), gettype($productName)), __LINE__);
        }
        $this->productName = $productName;
        return $this;
    }
    /**
     * Get region value
     * @return string|null
     */
    public function getRegion()
    {
        return $this->region;
    }
    /**
     * Set region value
     * @param string $region
     * @return \StructType\ProductOffer
     */
    public function setRegion($region = null)
    {
        // validation for constraint: string
        if (!is_null($region) && !is_string($region)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($region, true), gettype($region)), __LINE__);
        }
        $this->region = $region;
        return $this;
    }
    /**
     * Get regionName value
     * @return string|null
     */
    public function getRegionName()
    {
        return $this->regionName;
    }
    /**
     * Set regionName value
     * @param string $regionName
     * @return \StructType\ProductOffer
     */
    public function setRegionName($regionName = null)
    {
        // validation for constraint: string
        if (!is_null($regionName) && !is_string($regionName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($regionName, true), gettype($regionName)), __LINE__);
        }
        $this->regionName = $regionName;
        return $this;
    }
    /**
     * Get tariff value
     * @return string|null
     */
    public function getTariff()
    {
        return $this->tariff;
    }
    /**
     * Set tariff value
     * @param string $tariff
     * @return \StructType\ProductOffer
     */
    public function setTariff($tariff = null)
    {
        // validation for constraint: string
        if (!is_null($tariff) && !is_string($tariff)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tariff, true), gettype($tariff)), __LINE__);
        }
        $this->tariff = $tariff;
        return $this;
    }
    /**
     * Get tariffDescription value
     * @return string|null
     */
    public function getTariffDescription()
    {
        return $this->tariffDescription;
    }
    /**
     * Set tariffDescription value
     * @param string $tariffDescription
     * @return \StructType\ProductOffer
     */
    public function setTariffDescription($tariffDescription = null)
    {
        // validation for constraint: string
        if (!is_null($tariffDescription) && !is_string($tariffDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tariffDescription, true), gettype($tariffDescription)), __LINE__);
        }
        $this->tariffDescription = $tariffDescription;
        return $this;
    }
    /**
     * Get tariffGroupCode value
     * @return string|null
     */
    public function getTariffGroupCode()
    {
        return $this->tariffGroupCode;
    }
    /**
     * Set tariffGroupCode value
     * @param string $tariffGroupCode
     * @return \StructType\ProductOffer
     */
    public function setTariffGroupCode($tariffGroupCode = null)
    {
        // validation for constraint: string
        if (!is_null($tariffGroupCode) && !is_string($tariffGroupCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tariffGroupCode, true), gettype($tariffGroupCode)), __LINE__);
        }
        $this->tariffGroupCode = $tariffGroupCode;
        return $this;
    }
    /**
     * Get tariffGroupName value
     * @return string|null
     */
    public function getTariffGroupName()
    {
        return $this->tariffGroupName;
    }
    /**
     * Set tariffGroupName value
     * @param string $tariffGroupName
     * @return \StructType\ProductOffer
     */
    public function setTariffGroupName($tariffGroupName = null)
    {
        // validation for constraint: string
        if (!is_null($tariffGroupName) && !is_string($tariffGroupName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tariffGroupName, true), gettype($tariffGroupName)), __LINE__);
        }
        $this->tariffGroupName = $tariffGroupName;
        return $this;
    }
    /**
     * Get tariffGroupDescription value
     * @return string|null
     */
    public function getTariffGroupDescription()
    {
        return $this->tariffGroupDescription;
    }
    /**
     * Set tariffGroupDescription value
     * @param string $tariffGroupDescription
     * @return \StructType\ProductOffer
     */
    public function setTariffGroupDescription($tariffGroupDescription = null)
    {
        // validation for constraint: string
        if (!is_null($tariffGroupDescription) && !is_string($tariffGroupDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tariffGroupDescription, true), gettype($tariffGroupDescription)), __LINE__);
        }
        $this->tariffGroupDescription = $tariffGroupDescription;
        return $this;
    }
    /**
     * Get usageInfo value
     * @return string|null
     */
    public function getUsageInfo()
    {
        return $this->usageInfo;
    }
    /**
     * Set usageInfo value
     * @param string $usageInfo
     * @return \StructType\ProductOffer
     */
    public function setUsageInfo($usageInfo = null)
    {
        // validation for constraint: string
        if (!is_null($usageInfo) && !is_string($usageInfo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($usageInfo, true), gettype($usageInfo)), __LINE__);
        }
        $this->usageInfo = $usageInfo;
        return $this;
    }
    /**
     * Get prices value
     * @return \StructType\PriceInfo|null
     */
    public function getPrices()
    {
        return $this->prices;
    }
    /**
     * Set prices value
     * @param \StructType\PriceInfo $prices
     * @return \StructType\ProductOffer
     */
    public function setPrices(\StructType\PriceInfo $prices = null)
    {
        $this->prices = $prices;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ProductOffer
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
