<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PriceInfo StructType
 * @subpackage Structs
 */
class PriceInfo extends AbstractStructBase
{
    /**
     * The price
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\PriceCurrency[]
     */
    public $price;
    /**
     * Constructor method for PriceInfo
     * @uses PriceInfo::setPrice()
     * @param \StructType\PriceCurrency[] $price
     */
    public function __construct(array $price = array())
    {
        $this
            ->setPrice($price);
    }
    /**
     * Get price value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\PriceCurrency[]|null
     */
    public function getPrice()
    {
        return isset($this->price) ? $this->price : null;
    }
    /**
     * This method is responsible for validating the values passed to the setPrice method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPrice method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePriceForArrayConstraintsFromSetPrice(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $priceInfoPriceItem) {
            // validation for constraint: itemType
            if (!$priceInfoPriceItem instanceof \StructType\PriceCurrency) {
                $invalidValues[] = is_object($priceInfoPriceItem) ? get_class($priceInfoPriceItem) : sprintf('%s(%s)', gettype($priceInfoPriceItem), var_export($priceInfoPriceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The price property can only contain items of type \StructType\PriceCurrency, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set price value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\PriceCurrency[] $price
     * @return \StructType\PriceInfo
     */
    public function setPrice(array $price = array())
    {
        // validation for constraint: array
        if ('' !== ($priceArrayErrorMessage = self::validatePriceForArrayConstraintsFromSetPrice($price))) {
            throw new \InvalidArgumentException($priceArrayErrorMessage, __LINE__);
        }
        if (is_null($price) || (is_array($price) && empty($price))) {
            unset($this->price);
        } else {
            $this->price = $price;
        }
        return $this;
    }
    /**
     * Add item to price value
     * @throws \InvalidArgumentException
     * @param \StructType\PriceCurrency $item
     * @return \StructType\PriceInfo
     */
    public function addToPrice(\StructType\PriceCurrency $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PriceCurrency) {
            throw new \InvalidArgumentException(sprintf('The price property can only contain items of type \StructType\PriceCurrency, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->price[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PriceInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
