<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for getPolicyInfo StructType
 * Meta information extracted from the WSDL
 * - type: tns:getPolicyInfo
 * @subpackage Structs
 */
class GetPolicyInfo extends AbstractStructBase
{
    /**
     * The uniqueId
     * @var string
     */
    public $uniqueId;
    /**
     * The policyNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $policyNumber;
    /**
     * The policyRecId
     * @var string
     */
    public $policyRecId;
    /**
     * Constructor method for getPolicyInfo
     * @uses GetPolicyInfo::setUniqueId()
     * @uses GetPolicyInfo::setPolicyNumber()
     * @uses GetPolicyInfo::setPolicyRecId()
     * @param string $uniqueId
     * @param string $policyNumber
     * @param string $policyRecId
     */
    public function __construct($uniqueId = null, $policyNumber = null, $policyRecId = null)
    {
        $this
            ->setUniqueId($uniqueId)
            ->setPolicyNumber($policyNumber)
            ->setPolicyRecId($policyRecId);
    }
    /**
     * Get uniqueId value
     * @return string|null
     */
    public function getUniqueId()
    {
        return $this->uniqueId;
    }
    /**
     * Set uniqueId value
     * @param string $uniqueId
     * @return \StructType\GetPolicyInfo
     */
    public function setUniqueId($uniqueId = null)
    {
        // validation for constraint: string
        if (!is_null($uniqueId) && !is_string($uniqueId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uniqueId, true), gettype($uniqueId)), __LINE__);
        }
        $this->uniqueId = $uniqueId;
        return $this;
    }
    /**
     * Get policyNumber value
     * @return string|null
     */
    public function getPolicyNumber()
    {
        return $this->policyNumber;
    }
    /**
     * Set policyNumber value
     * @param string $policyNumber
     * @return \StructType\GetPolicyInfo
     */
    public function setPolicyNumber($policyNumber = null)
    {
        // validation for constraint: string
        if (!is_null($policyNumber) && !is_string($policyNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($policyNumber, true), gettype($policyNumber)), __LINE__);
        }
        $this->policyNumber = $policyNumber;
        return $this;
    }
    /**
     * Get policyRecId value
     * @return string|null
     */
    public function getPolicyRecId()
    {
        return $this->policyRecId;
    }
    /**
     * Set policyRecId value
     * @param string $policyRecId
     * @return \StructType\GetPolicyInfo
     */
    public function setPolicyRecId($policyRecId = null)
    {
        // validation for constraint: string
        if (!is_null($policyRecId) && !is_string($policyRecId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($policyRecId, true), gettype($policyRecId)), __LINE__);
        }
        $this->policyRecId = $policyRecId;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetPolicyInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
