<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for getCheapestProduct StructType
 * Meta information extracted from the WSDL
 * - type: tns:getCheapestProduct
 * @subpackage Structs
 */
class GetCheapestProduct extends AbstractStructBase
{
    /**
     * The uniqueId
     * @var string
     */
    public $uniqueId;
    /**
     * The insuredDays
     * @var int
     */
    public $insuredDays;
    /**
     * The region
     * @var string
     */
    public $region;
    /**
     * The insuredsCount
     * @var int
     */
    public $insuredsCount;
    /**
     * The tariffType
     * @var string
     */
    public $tariffType;
    /**
     * The currency
     * @var string
     */
    public $currency;
    /**
     * The language
     * @var string
     */
    public $language;
    /**
     * The strictRegion
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $strictRegion;
    /**
     * Constructor method for getCheapestProduct
     * @uses GetCheapestProduct::setUniqueId()
     * @uses GetCheapestProduct::setInsuredDays()
     * @uses GetCheapestProduct::setRegion()
     * @uses GetCheapestProduct::setInsuredsCount()
     * @uses GetCheapestProduct::setTariffType()
     * @uses GetCheapestProduct::setCurrency()
     * @uses GetCheapestProduct::setLanguage()
     * @uses GetCheapestProduct::setStrictRegion()
     * @param string $uniqueId
     * @param int $insuredDays
     * @param string $region
     * @param int $insuredsCount
     * @param string $tariffType
     * @param string $currency
     * @param string $language
     * @param bool $strictRegion
     */
    public function __construct($uniqueId = null, $insuredDays = null, $region = null, $insuredsCount = null, $tariffType = null, $currency = null, $language = null, $strictRegion = null)
    {
        $this
            ->setUniqueId($uniqueId)
            ->setInsuredDays($insuredDays)
            ->setRegion($region)
            ->setInsuredsCount($insuredsCount)
            ->setTariffType($tariffType)
            ->setCurrency($currency)
            ->setLanguage($language)
            ->setStrictRegion($strictRegion);
    }
    /**
     * Get uniqueId value
     * @return string|null
     */
    public function getUniqueId()
    {
        return $this->uniqueId;
    }
    /**
     * Set uniqueId value
     * @param string $uniqueId
     * @return \StructType\GetCheapestProduct
     */
    public function setUniqueId($uniqueId = null)
    {
        // validation for constraint: string
        if (!is_null($uniqueId) && !is_string($uniqueId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uniqueId, true), gettype($uniqueId)), __LINE__);
        }
        $this->uniqueId = $uniqueId;
        return $this;
    }
    /**
     * Get insuredDays value
     * @return int|null
     */
    public function getInsuredDays()
    {
        return $this->insuredDays;
    }
    /**
     * Set insuredDays value
     * @param int $insuredDays
     * @return \StructType\GetCheapestProduct
     */
    public function setInsuredDays($insuredDays = null)
    {
        // validation for constraint: int
        if (!is_null($insuredDays) && !(is_int($insuredDays) || ctype_digit($insuredDays))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($insuredDays, true), gettype($insuredDays)), __LINE__);
        }
        $this->insuredDays = $insuredDays;
        return $this;
    }
    /**
     * Get region value
     * @return string|null
     */
    public function getRegion()
    {
        return $this->region;
    }
    /**
     * Set region value
     * @param string $region
     * @return \StructType\GetCheapestProduct
     */
    public function setRegion($region = null)
    {
        // validation for constraint: string
        if (!is_null($region) && !is_string($region)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($region, true), gettype($region)), __LINE__);
        }
        $this->region = $region;
        return $this;
    }
    /**
     * Get insuredsCount value
     * @return int|null
     */
    public function getInsuredsCount()
    {
        return $this->insuredsCount;
    }
    /**
     * Set insuredsCount value
     * @param int $insuredsCount
     * @return \StructType\GetCheapestProduct
     */
    public function setInsuredsCount($insuredsCount = null)
    {
        // validation for constraint: int
        if (!is_null($insuredsCount) && !(is_int($insuredsCount) || ctype_digit($insuredsCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($insuredsCount, true), gettype($insuredsCount)), __LINE__);
        }
        $this->insuredsCount = $insuredsCount;
        return $this;
    }
    /**
     * Get tariffType value
     * @return string|null
     */
    public function getTariffType()
    {
        return $this->tariffType;
    }
    /**
     * Set tariffType value
     * @param string $tariffType
     * @return \StructType\GetCheapestProduct
     */
    public function setTariffType($tariffType = null)
    {
        // validation for constraint: string
        if (!is_null($tariffType) && !is_string($tariffType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tariffType, true), gettype($tariffType)), __LINE__);
        }
        $this->tariffType = $tariffType;
        return $this;
    }
    /**
     * Get currency value
     * @return string|null
     */
    public function getCurrency()
    {
        return $this->currency;
    }
    /**
     * Set currency value
     * @param string $currency
     * @return \StructType\GetCheapestProduct
     */
    public function setCurrency($currency = null)
    {
        // validation for constraint: string
        if (!is_null($currency) && !is_string($currency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currency, true), gettype($currency)), __LINE__);
        }
        $this->currency = $currency;
        return $this;
    }
    /**
     * Get language value
     * @return string|null
     */
    public function getLanguage()
    {
        return $this->language;
    }
    /**
     * Set language value
     * @param string $language
     * @return \StructType\GetCheapestProduct
     */
    public function setLanguage($language = null)
    {
        // validation for constraint: string
        if (!is_null($language) && !is_string($language)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($language, true), gettype($language)), __LINE__);
        }
        $this->language = $language;
        return $this;
    }
    /**
     * Get strictRegion value
     * @return bool|null
     */
    public function getStrictRegion()
    {
        return $this->strictRegion;
    }
    /**
     * Set strictRegion value
     * @param bool $strictRegion
     * @return \StructType\GetCheapestProduct
     */
    public function setStrictRegion($strictRegion = null)
    {
        // validation for constraint: boolean
        if (!is_null($strictRegion) && !is_bool($strictRegion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($strictRegion, true), gettype($strictRegion)), __LINE__);
        }
        $this->strictRegion = $strictRegion;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetCheapestProduct
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
