<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SuitableTariffGroup StructType
 * @subpackage Structs
 */
class SuitableTariffGroup extends AbstractStructBase
{
    /**
     * The additional
     * @var bool
     */
    public $additional;
    /**
     * The groupCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $groupCode;
    /**
     * The groupName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $groupName;
    /**
     * The groupDescription
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $groupDescription;
    /**
     * The selection
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $selection;
    /**
     * The variants
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $variants;
    /**
     * The tariffSpec
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $tariffSpec;
    /**
     * The tariffType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $tariffType;
    /**
     * The tariff
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\SuitableTariff[]
     */
    public $tariff;
    /**
     * Constructor method for SuitableTariffGroup
     * @uses SuitableTariffGroup::setAdditional()
     * @uses SuitableTariffGroup::setGroupCode()
     * @uses SuitableTariffGroup::setGroupName()
     * @uses SuitableTariffGroup::setGroupDescription()
     * @uses SuitableTariffGroup::setSelection()
     * @uses SuitableTariffGroup::setVariants()
     * @uses SuitableTariffGroup::setTariffSpec()
     * @uses SuitableTariffGroup::setTariffType()
     * @uses SuitableTariffGroup::setTariff()
     * @param bool $additional
     * @param string $groupCode
     * @param string $groupName
     * @param string $groupDescription
     * @param string $selection
     * @param string $variants
     * @param string $tariffSpec
     * @param string $tariffType
     * @param \StructType\SuitableTariff[] $tariff
     */
    public function __construct($additional = null, $groupCode = null, $groupName = null, $groupDescription = null, $selection = null, $variants = null, $tariffSpec = null, $tariffType = null, array $tariff = array())
    {
        $this
            ->setAdditional($additional)
            ->setGroupCode($groupCode)
            ->setGroupName($groupName)
            ->setGroupDescription($groupDescription)
            ->setSelection($selection)
            ->setVariants($variants)
            ->setTariffSpec($tariffSpec)
            ->setTariffType($tariffType)
            ->setTariff($tariff);
    }
    /**
     * Get additional value
     * @return bool|null
     */
    public function getAdditional()
    {
        return $this->additional;
    }
    /**
     * Set additional value
     * @param bool $additional
     * @return \StructType\SuitableTariffGroup
     */
    public function setAdditional($additional = null)
    {
        // validation for constraint: boolean
        if (!is_null($additional) && !is_bool($additional)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($additional, true), gettype($additional)), __LINE__);
        }
        $this->additional = $additional;
        return $this;
    }
    /**
     * Get groupCode value
     * @return string|null
     */
    public function getGroupCode()
    {
        return $this->groupCode;
    }
    /**
     * Set groupCode value
     * @param string $groupCode
     * @return \StructType\SuitableTariffGroup
     */
    public function setGroupCode($groupCode = null)
    {
        // validation for constraint: string
        if (!is_null($groupCode) && !is_string($groupCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($groupCode, true), gettype($groupCode)), __LINE__);
        }
        $this->groupCode = $groupCode;
        return $this;
    }
    /**
     * Get groupName value
     * @return string|null
     */
    public function getGroupName()
    {
        return $this->groupName;
    }
    /**
     * Set groupName value
     * @param string $groupName
     * @return \StructType\SuitableTariffGroup
     */
    public function setGroupName($groupName = null)
    {
        // validation for constraint: string
        if (!is_null($groupName) && !is_string($groupName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($groupName, true), gettype($groupName)), __LINE__);
        }
        $this->groupName = $groupName;
        return $this;
    }
    /**
     * Get groupDescription value
     * @return string|null
     */
    public function getGroupDescription()
    {
        return $this->groupDescription;
    }
    /**
     * Set groupDescription value
     * @param string $groupDescription
     * @return \StructType\SuitableTariffGroup
     */
    public function setGroupDescription($groupDescription = null)
    {
        // validation for constraint: string
        if (!is_null($groupDescription) && !is_string($groupDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($groupDescription, true), gettype($groupDescription)), __LINE__);
        }
        $this->groupDescription = $groupDescription;
        return $this;
    }
    /**
     * Get selection value
     * @return string|null
     */
    public function getSelection()
    {
        return $this->selection;
    }
    /**
     * Set selection value
     * @param string $selection
     * @return \StructType\SuitableTariffGroup
     */
    public function setSelection($selection = null)
    {
        // validation for constraint: string
        if (!is_null($selection) && !is_string($selection)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($selection, true), gettype($selection)), __LINE__);
        }
        $this->selection = $selection;
        return $this;
    }
    /**
     * Get variants value
     * @return string|null
     */
    public function getVariants()
    {
        return $this->variants;
    }
    /**
     * Set variants value
     * @param string $variants
     * @return \StructType\SuitableTariffGroup
     */
    public function setVariants($variants = null)
    {
        // validation for constraint: string
        if (!is_null($variants) && !is_string($variants)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($variants, true), gettype($variants)), __LINE__);
        }
        $this->variants = $variants;
        return $this;
    }
    /**
     * Get tariffSpec value
     * @return string|null
     */
    public function getTariffSpec()
    {
        return $this->tariffSpec;
    }
    /**
     * Set tariffSpec value
     * @param string $tariffSpec
     * @return \StructType\SuitableTariffGroup
     */
    public function setTariffSpec($tariffSpec = null)
    {
        // validation for constraint: string
        if (!is_null($tariffSpec) && !is_string($tariffSpec)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tariffSpec, true), gettype($tariffSpec)), __LINE__);
        }
        $this->tariffSpec = $tariffSpec;
        return $this;
    }
    /**
     * Get tariffType value
     * @return string|null
     */
    public function getTariffType()
    {
        return $this->tariffType;
    }
    /**
     * Set tariffType value
     * @param string $tariffType
     * @return \StructType\SuitableTariffGroup
     */
    public function setTariffType($tariffType = null)
    {
        // validation for constraint: string
        if (!is_null($tariffType) && !is_string($tariffType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tariffType, true), gettype($tariffType)), __LINE__);
        }
        $this->tariffType = $tariffType;
        return $this;
    }
    /**
     * Get tariff value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\SuitableTariff[]|null
     */
    public function getTariff()
    {
        return isset($this->tariff) ? $this->tariff : null;
    }
    /**
     * This method is responsible for validating the values passed to the setTariff method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTariff method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTariffForArrayConstraintsFromSetTariff(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $suitableTariffGroupTariffItem) {
            // validation for constraint: itemType
            if (!$suitableTariffGroupTariffItem instanceof \StructType\SuitableTariff) {
                $invalidValues[] = is_object($suitableTariffGroupTariffItem) ? get_class($suitableTariffGroupTariffItem) : sprintf('%s(%s)', gettype($suitableTariffGroupTariffItem), var_export($suitableTariffGroupTariffItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The tariff property can only contain items of type \StructType\SuitableTariff, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set tariff value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\SuitableTariff[] $tariff
     * @return \StructType\SuitableTariffGroup
     */
    public function setTariff(array $tariff = array())
    {
        // validation for constraint: array
        if ('' !== ($tariffArrayErrorMessage = self::validateTariffForArrayConstraintsFromSetTariff($tariff))) {
            throw new \InvalidArgumentException($tariffArrayErrorMessage, __LINE__);
        }
        if (is_null($tariff) || (is_array($tariff) && empty($tariff))) {
            unset($this->tariff);
        } else {
            $this->tariff = $tariff;
        }
        return $this;
    }
    /**
     * Add item to tariff value
     * @throws \InvalidArgumentException
     * @param \StructType\SuitableTariff $item
     * @return \StructType\SuitableTariffGroup
     */
    public function addToTariff(\StructType\SuitableTariff $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SuitableTariff) {
            throw new \InvalidArgumentException(sprintf('The tariff property can only contain items of type \StructType\SuitableTariff, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->tariff[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SuitableTariffGroup
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
