<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Region StructType
 * @subpackage Structs
 */
class Region extends AbstractStructBase
{
    /**
     * The regionCode
     * @var string
     */
    public $regionCode;
    /**
     * The regionName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $regionName;
    /**
     * The regions
     * @var string
     */
    public $regions;
    /**
     * Constructor method for Region
     * @uses Region::setRegionCode()
     * @uses Region::setRegionName()
     * @uses Region::setRegions()
     * @param string $regionCode
     * @param string $regionName
     * @param string $regions
     */
    public function __construct($regionCode = null, $regionName = null, $regions = null)
    {
        $this
            ->setRegionCode($regionCode)
            ->setRegionName($regionName)
            ->setRegions($regions);
    }
    /**
     * Get regionCode value
     * @return string|null
     */
    public function getRegionCode()
    {
        return $this->regionCode;
    }
    /**
     * Set regionCode value
     * @param string $regionCode
     * @return \StructType\Region
     */
    public function setRegionCode($regionCode = null)
    {
        // validation for constraint: string
        if (!is_null($regionCode) && !is_string($regionCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($regionCode, true), gettype($regionCode)), __LINE__);
        }
        $this->regionCode = $regionCode;
        return $this;
    }
    /**
     * Get regionName value
     * @return string|null
     */
    public function getRegionName()
    {
        return $this->regionName;
    }
    /**
     * Set regionName value
     * @param string $regionName
     * @return \StructType\Region
     */
    public function setRegionName($regionName = null)
    {
        // validation for constraint: string
        if (!is_null($regionName) && !is_string($regionName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($regionName, true), gettype($regionName)), __LINE__);
        }
        $this->regionName = $regionName;
        return $this;
    }
    /**
     * Get regions value
     * @return string|null
     */
    public function getRegions()
    {
        return $this->regions;
    }
    /**
     * Set regions value
     * @param string $regions
     * @return \StructType\Region
     */
    public function setRegions($regions = null)
    {
        // validation for constraint: string
        if (!is_null($regions) && !is_string($regions)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($regions, true), gettype($regions)), __LINE__);
        }
        $this->regions = $regions;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Region
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
