<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PolicyListParms StructType
 * @subpackage Structs
 */
class PolicyListParms extends AbstractStructBase
{
    /**
     * The acntMonth
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $acntMonth;
    /**
     * The acntYear
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $acntYear;
    /**
     * The issuedFrom
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $issuedFrom;
    /**
     * The issuedTo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $issuedTo;
    /**
     * The startDayFrom
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $startDayFrom;
    /**
     * The startDayTo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $startDayTo;
    /**
     * The wsChannelOnly
     * @var bool
     */
    public $wsChannelOnly;
    /**
     * Constructor method for PolicyListParms
     * @uses PolicyListParms::setAcntMonth()
     * @uses PolicyListParms::setAcntYear()
     * @uses PolicyListParms::setIssuedFrom()
     * @uses PolicyListParms::setIssuedTo()
     * @uses PolicyListParms::setStartDayFrom()
     * @uses PolicyListParms::setStartDayTo()
     * @uses PolicyListParms::setWsChannelOnly()
     * @param int $acntMonth
     * @param int $acntYear
     * @param string $issuedFrom
     * @param string $issuedTo
     * @param string $startDayFrom
     * @param string $startDayTo
     * @param bool $wsChannelOnly
     */
    public function __construct($acntMonth = null, $acntYear = null, $issuedFrom = null, $issuedTo = null, $startDayFrom = null, $startDayTo = null, $wsChannelOnly = null)
    {
        $this
            ->setAcntMonth($acntMonth)
            ->setAcntYear($acntYear)
            ->setIssuedFrom($issuedFrom)
            ->setIssuedTo($issuedTo)
            ->setStartDayFrom($startDayFrom)
            ->setStartDayTo($startDayTo)
            ->setWsChannelOnly($wsChannelOnly);
    }
    /**
     * Get acntMonth value
     * @return int|null
     */
    public function getAcntMonth()
    {
        return $this->acntMonth;
    }
    /**
     * Set acntMonth value
     * @param int $acntMonth
     * @return \StructType\PolicyListParms
     */
    public function setAcntMonth($acntMonth = null)
    {
        // validation for constraint: int
        if (!is_null($acntMonth) && !(is_int($acntMonth) || ctype_digit($acntMonth))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($acntMonth, true), gettype($acntMonth)), __LINE__);
        }
        $this->acntMonth = $acntMonth;
        return $this;
    }
    /**
     * Get acntYear value
     * @return int|null
     */
    public function getAcntYear()
    {
        return $this->acntYear;
    }
    /**
     * Set acntYear value
     * @param int $acntYear
     * @return \StructType\PolicyListParms
     */
    public function setAcntYear($acntYear = null)
    {
        // validation for constraint: int
        if (!is_null($acntYear) && !(is_int($acntYear) || ctype_digit($acntYear))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($acntYear, true), gettype($acntYear)), __LINE__);
        }
        $this->acntYear = $acntYear;
        return $this;
    }
    /**
     * Get issuedFrom value
     * @return string|null
     */
    public function getIssuedFrom()
    {
        return $this->issuedFrom;
    }
    /**
     * Set issuedFrom value
     * @param string $issuedFrom
     * @return \StructType\PolicyListParms
     */
    public function setIssuedFrom($issuedFrom = null)
    {
        // validation for constraint: string
        if (!is_null($issuedFrom) && !is_string($issuedFrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($issuedFrom, true), gettype($issuedFrom)), __LINE__);
        }
        $this->issuedFrom = $issuedFrom;
        return $this;
    }
    /**
     * Get issuedTo value
     * @return string|null
     */
    public function getIssuedTo()
    {
        return $this->issuedTo;
    }
    /**
     * Set issuedTo value
     * @param string $issuedTo
     * @return \StructType\PolicyListParms
     */
    public function setIssuedTo($issuedTo = null)
    {
        // validation for constraint: string
        if (!is_null($issuedTo) && !is_string($issuedTo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($issuedTo, true), gettype($issuedTo)), __LINE__);
        }
        $this->issuedTo = $issuedTo;
        return $this;
    }
    /**
     * Get startDayFrom value
     * @return string|null
     */
    public function getStartDayFrom()
    {
        return $this->startDayFrom;
    }
    /**
     * Set startDayFrom value
     * @param string $startDayFrom
     * @return \StructType\PolicyListParms
     */
    public function setStartDayFrom($startDayFrom = null)
    {
        // validation for constraint: string
        if (!is_null($startDayFrom) && !is_string($startDayFrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($startDayFrom, true), gettype($startDayFrom)), __LINE__);
        }
        $this->startDayFrom = $startDayFrom;
        return $this;
    }
    /**
     * Get startDayTo value
     * @return string|null
     */
    public function getStartDayTo()
    {
        return $this->startDayTo;
    }
    /**
     * Set startDayTo value
     * @param string $startDayTo
     * @return \StructType\PolicyListParms
     */
    public function setStartDayTo($startDayTo = null)
    {
        // validation for constraint: string
        if (!is_null($startDayTo) && !is_string($startDayTo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($startDayTo, true), gettype($startDayTo)), __LINE__);
        }
        $this->startDayTo = $startDayTo;
        return $this;
    }
    /**
     * Get wsChannelOnly value
     * @return bool|null
     */
    public function getWsChannelOnly()
    {
        return $this->wsChannelOnly;
    }
    /**
     * Set wsChannelOnly value
     * @param bool $wsChannelOnly
     * @return \StructType\PolicyListParms
     */
    public function setWsChannelOnly($wsChannelOnly = null)
    {
        // validation for constraint: boolean
        if (!is_null($wsChannelOnly) && !is_bool($wsChannelOnly)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($wsChannelOnly, true), gettype($wsChannelOnly)), __LINE__);
        }
        $this->wsChannelOnly = $wsChannelOnly;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PolicyListParms
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
