<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PolicyInfo StructType
 * @subpackage Structs
 */
class PolicyInfo extends AbstractStructBase
{
    /**
     * The agentCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $agentCode;
    /**
     * The currency
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $currency;
    /**
     * The discount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $discount;
    /**
     * The insureds
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\InsuredPersonParms[]
     */
    public $insureds;
    /**
     * The issuedOn
     * @var string
     */
    public $issuedOn;
    /**
     * The lastDay
     * @var string
     */
    public $lastDay;
    /**
     * The policyHolder
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\PolicyHolderParms
     */
    public $policyHolder;
    /**
     * The policyNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $policyNumber;
    /**
     * The policyRecId
     * @var string
     */
    public $policyRecId;
    /**
     * The policyStatus
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $policyStatus;
    /**
     * The price
     * @var float
     */
    public $price;
    /**
     * The productCode
     * @var string
     */
    public $productCode;
    /**
     * The remark
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $remark;
    /**
     * The seller
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $seller;
    /**
     * The totalDays
     * @var int
     */
    public $totalDays;
    /**
     * The startDay
     * @var string
     */
    public $startDay;
    /**
     * The prices
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\PriceInfo
     */
    public $prices;
    /**
     * Constructor method for PolicyInfo
     * @uses PolicyInfo::setAgentCode()
     * @uses PolicyInfo::setCurrency()
     * @uses PolicyInfo::setDiscount()
     * @uses PolicyInfo::setInsureds()
     * @uses PolicyInfo::setIssuedOn()
     * @uses PolicyInfo::setLastDay()
     * @uses PolicyInfo::setPolicyHolder()
     * @uses PolicyInfo::setPolicyNumber()
     * @uses PolicyInfo::setPolicyRecId()
     * @uses PolicyInfo::setPolicyStatus()
     * @uses PolicyInfo::setPrice()
     * @uses PolicyInfo::setProductCode()
     * @uses PolicyInfo::setRemark()
     * @uses PolicyInfo::setSeller()
     * @uses PolicyInfo::setTotalDays()
     * @uses PolicyInfo::setStartDay()
     * @uses PolicyInfo::setPrices()
     * @param string $agentCode
     * @param string $currency
     * @param float $discount
     * @param \StructType\InsuredPersonParms[] $insureds
     * @param string $issuedOn
     * @param string $lastDay
     * @param \StructType\PolicyHolderParms $policyHolder
     * @param string $policyNumber
     * @param string $policyRecId
     * @param string $policyStatus
     * @param float $price
     * @param string $productCode
     * @param string $remark
     * @param string $seller
     * @param int $totalDays
     * @param string $startDay
     * @param \StructType\PriceInfo $prices
     */
    public function __construct($agentCode = null, $currency = null, $discount = null, array $insureds = array(), $issuedOn = null, $lastDay = null, \StructType\PolicyHolderParms $policyHolder = null, $policyNumber = null, $policyRecId = null, $policyStatus = null, $price = null, $productCode = null, $remark = null, $seller = null, $totalDays = null, $startDay = null, \StructType\PriceInfo $prices = null)
    {
        $this
            ->setAgentCode($agentCode)
            ->setCurrency($currency)
            ->setDiscount($discount)
            ->setInsureds($insureds)
            ->setIssuedOn($issuedOn)
            ->setLastDay($lastDay)
            ->setPolicyHolder($policyHolder)
            ->setPolicyNumber($policyNumber)
            ->setPolicyRecId($policyRecId)
            ->setPolicyStatus($policyStatus)
            ->setPrice($price)
            ->setProductCode($productCode)
            ->setRemark($remark)
            ->setSeller($seller)
            ->setTotalDays($totalDays)
            ->setStartDay($startDay)
            ->setPrices($prices);
    }
    /**
     * Get agentCode value
     * @return string|null
     */
    public function getAgentCode()
    {
        return $this->agentCode;
    }
    /**
     * Set agentCode value
     * @param string $agentCode
     * @return \StructType\PolicyInfo
     */
    public function setAgentCode($agentCode = null)
    {
        // validation for constraint: string
        if (!is_null($agentCode) && !is_string($agentCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($agentCode, true), gettype($agentCode)), __LINE__);
        }
        $this->agentCode = $agentCode;
        return $this;
    }
    /**
     * Get currency value
     * @return string|null
     */
    public function getCurrency()
    {
        return $this->currency;
    }
    /**
     * Set currency value
     * @param string $currency
     * @return \StructType\PolicyInfo
     */
    public function setCurrency($currency = null)
    {
        // validation for constraint: string
        if (!is_null($currency) && !is_string($currency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currency, true), gettype($currency)), __LINE__);
        }
        $this->currency = $currency;
        return $this;
    }
    /**
     * Get discount value
     * @return float|null
     */
    public function getDiscount()
    {
        return $this->discount;
    }
    /**
     * Set discount value
     * @param float $discount
     * @return \StructType\PolicyInfo
     */
    public function setDiscount($discount = null)
    {
        // validation for constraint: float
        if (!is_null($discount) && !(is_float($discount) || is_numeric($discount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($discount, true), gettype($discount)), __LINE__);
        }
        $this->discount = $discount;
        return $this;
    }
    /**
     * Get insureds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\InsuredPersonParms[]|null
     */
    public function getInsureds()
    {
        return isset($this->insureds) ? $this->insureds : null;
    }
    /**
     * This method is responsible for validating the values passed to the setInsureds method
     * This method is willingly generated in order to preserve the one-line inline validation within the setInsureds method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateInsuredsForArrayConstraintsFromSetInsureds(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $policyInfoInsuredsItem) {
            // validation for constraint: itemType
            if (!$policyInfoInsuredsItem instanceof \StructType\InsuredPersonParms) {
                $invalidValues[] = is_object($policyInfoInsuredsItem) ? get_class($policyInfoInsuredsItem) : sprintf('%s(%s)', gettype($policyInfoInsuredsItem), var_export($policyInfoInsuredsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The insureds property can only contain items of type \StructType\InsuredPersonParms, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set insureds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\InsuredPersonParms[] $insureds
     * @return \StructType\PolicyInfo
     */
    public function setInsureds(array $insureds = array())
    {
        // validation for constraint: array
        if ('' !== ($insuredsArrayErrorMessage = self::validateInsuredsForArrayConstraintsFromSetInsureds($insureds))) {
            throw new \InvalidArgumentException($insuredsArrayErrorMessage, __LINE__);
        }
        if (is_null($insureds) || (is_array($insureds) && empty($insureds))) {
            unset($this->insureds);
        } else {
            $this->insureds = $insureds;
        }
        return $this;
    }
    /**
     * Add item to insureds value
     * @throws \InvalidArgumentException
     * @param \StructType\InsuredPersonParms $item
     * @return \StructType\PolicyInfo
     */
    public function addToInsureds(\StructType\InsuredPersonParms $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\InsuredPersonParms) {
            throw new \InvalidArgumentException(sprintf('The insureds property can only contain items of type \StructType\InsuredPersonParms, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->insureds[] = $item;
        return $this;
    }
    /**
     * Get issuedOn value
     * @return string|null
     */
    public function getIssuedOn()
    {
        return $this->issuedOn;
    }
    /**
     * Set issuedOn value
     * @param string $issuedOn
     * @return \StructType\PolicyInfo
     */
    public function setIssuedOn($issuedOn = null)
    {
        // validation for constraint: string
        if (!is_null($issuedOn) && !is_string($issuedOn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($issuedOn, true), gettype($issuedOn)), __LINE__);
        }
        $this->issuedOn = $issuedOn;
        return $this;
    }
    /**
     * Get lastDay value
     * @return string|null
     */
    public function getLastDay()
    {
        return $this->lastDay;
    }
    /**
     * Set lastDay value
     * @param string $lastDay
     * @return \StructType\PolicyInfo
     */
    public function setLastDay($lastDay = null)
    {
        // validation for constraint: string
        if (!is_null($lastDay) && !is_string($lastDay)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastDay, true), gettype($lastDay)), __LINE__);
        }
        $this->lastDay = $lastDay;
        return $this;
    }
    /**
     * Get policyHolder value
     * @return \StructType\PolicyHolderParms|null
     */
    public function getPolicyHolder()
    {
        return $this->policyHolder;
    }
    /**
     * Set policyHolder value
     * @param \StructType\PolicyHolderParms $policyHolder
     * @return \StructType\PolicyInfo
     */
    public function setPolicyHolder(\StructType\PolicyHolderParms $policyHolder = null)
    {
        $this->policyHolder = $policyHolder;
        return $this;
    }
    /**
     * Get policyNumber value
     * @return string|null
     */
    public function getPolicyNumber()
    {
        return $this->policyNumber;
    }
    /**
     * Set policyNumber value
     * @param string $policyNumber
     * @return \StructType\PolicyInfo
     */
    public function setPolicyNumber($policyNumber = null)
    {
        // validation for constraint: string
        if (!is_null($policyNumber) && !is_string($policyNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($policyNumber, true), gettype($policyNumber)), __LINE__);
        }
        $this->policyNumber = $policyNumber;
        return $this;
    }
    /**
     * Get policyRecId value
     * @return string|null
     */
    public function getPolicyRecId()
    {
        return $this->policyRecId;
    }
    /**
     * Set policyRecId value
     * @param string $policyRecId
     * @return \StructType\PolicyInfo
     */
    public function setPolicyRecId($policyRecId = null)
    {
        // validation for constraint: string
        if (!is_null($policyRecId) && !is_string($policyRecId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($policyRecId, true), gettype($policyRecId)), __LINE__);
        }
        $this->policyRecId = $policyRecId;
        return $this;
    }
    /**
     * Get policyStatus value
     * @return string|null
     */
    public function getPolicyStatus()
    {
        return $this->policyStatus;
    }
    /**
     * Set policyStatus value
     * @param string $policyStatus
     * @return \StructType\PolicyInfo
     */
    public function setPolicyStatus($policyStatus = null)
    {
        // validation for constraint: string
        if (!is_null($policyStatus) && !is_string($policyStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($policyStatus, true), gettype($policyStatus)), __LINE__);
        }
        $this->policyStatus = $policyStatus;
        return $this;
    }
    /**
     * Get price value
     * @return float|null
     */
    public function getPrice()
    {
        return $this->price;
    }
    /**
     * Set price value
     * @param float $price
     * @return \StructType\PolicyInfo
     */
    public function setPrice($price = null)
    {
        // validation for constraint: float
        if (!is_null($price) && !(is_float($price) || is_numeric($price))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($price, true), gettype($price)), __LINE__);
        }
        $this->price = $price;
        return $this;
    }
    /**
     * Get productCode value
     * @return string|null
     */
    public function getProductCode()
    {
        return $this->productCode;
    }
    /**
     * Set productCode value
     * @param string $productCode
     * @return \StructType\PolicyInfo
     */
    public function setProductCode($productCode = null)
    {
        // validation for constraint: string
        if (!is_null($productCode) && !is_string($productCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($productCode, true), gettype($productCode)), __LINE__);
        }
        $this->productCode = $productCode;
        return $this;
    }
    /**
     * Get remark value
     * @return string|null
     */
    public function getRemark()
    {
        return $this->remark;
    }
    /**
     * Set remark value
     * @param string $remark
     * @return \StructType\PolicyInfo
     */
    public function setRemark($remark = null)
    {
        // validation for constraint: string
        if (!is_null($remark) && !is_string($remark)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($remark, true), gettype($remark)), __LINE__);
        }
        $this->remark = $remark;
        return $this;
    }
    /**
     * Get seller value
     * @return string|null
     */
    public function getSeller()
    {
        return $this->seller;
    }
    /**
     * Set seller value
     * @param string $seller
     * @return \StructType\PolicyInfo
     */
    public function setSeller($seller = null)
    {
        // validation for constraint: string
        if (!is_null($seller) && !is_string($seller)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seller, true), gettype($seller)), __LINE__);
        }
        $this->seller = $seller;
        return $this;
    }
    /**
     * Get totalDays value
     * @return int|null
     */
    public function getTotalDays()
    {
        return $this->totalDays;
    }
    /**
     * Set totalDays value
     * @param int $totalDays
     * @return \StructType\PolicyInfo
     */
    public function setTotalDays($totalDays = null)
    {
        // validation for constraint: int
        if (!is_null($totalDays) && !(is_int($totalDays) || ctype_digit($totalDays))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($totalDays, true), gettype($totalDays)), __LINE__);
        }
        $this->totalDays = $totalDays;
        return $this;
    }
    /**
     * Get startDay value
     * @return string|null
     */
    public function getStartDay()
    {
        return $this->startDay;
    }
    /**
     * Set startDay value
     * @param string $startDay
     * @return \StructType\PolicyInfo
     */
    public function setStartDay($startDay = null)
    {
        // validation for constraint: string
        if (!is_null($startDay) && !is_string($startDay)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($startDay, true), gettype($startDay)), __LINE__);
        }
        $this->startDay = $startDay;
        return $this;
    }
    /**
     * Get prices value
     * @return \StructType\PriceInfo|null
     */
    public function getPrices()
    {
        return $this->prices;
    }
    /**
     * Set prices value
     * @param \StructType\PriceInfo $prices
     * @return \StructType\PolicyInfo
     */
    public function setPrices(\StructType\PriceInfo $prices = null)
    {
        $this->prices = $prices;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PolicyInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
