<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PolicyCalculatePremiumParms StructType
 * @subpackage Structs
 */
class PolicyCalculatePremiumParms extends AbstractStructBase
{
    /**
     * The insureds
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \StructType\InsuredPersonCalculatePremiumParms[]
     */
    public $insureds;
    /**
     * The issuedOn
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $issuedOn;
    /**
     * The lastDay
     * @var string
     */
    public $lastDay;
    /**
     * The productCode
     * @var string
     */
    public $productCode;
    /**
     * The regionCode
     * @var string
     */
    public $regionCode;
    /**
     * The startDay
     * @var string
     */
    public $startDay;
    /**
     * The totalDays
     * @var int
     */
    public $totalDays;
    /**
     * Constructor method for PolicyCalculatePremiumParms
     * @uses PolicyCalculatePremiumParms::setInsureds()
     * @uses PolicyCalculatePremiumParms::setIssuedOn()
     * @uses PolicyCalculatePremiumParms::setLastDay()
     * @uses PolicyCalculatePremiumParms::setProductCode()
     * @uses PolicyCalculatePremiumParms::setRegionCode()
     * @uses PolicyCalculatePremiumParms::setStartDay()
     * @uses PolicyCalculatePremiumParms::setTotalDays()
     * @param \StructType\InsuredPersonCalculatePremiumParms[] $insureds
     * @param string $issuedOn
     * @param string $lastDay
     * @param string $productCode
     * @param string $regionCode
     * @param string $startDay
     * @param int $totalDays
     */
    public function __construct(array $insureds = array(), $issuedOn = null, $lastDay = null, $productCode = null, $regionCode = null, $startDay = null, $totalDays = null)
    {
        $this
            ->setInsureds($insureds)
            ->setIssuedOn($issuedOn)
            ->setLastDay($lastDay)
            ->setProductCode($productCode)
            ->setRegionCode($regionCode)
            ->setStartDay($startDay)
            ->setTotalDays($totalDays);
    }
    /**
     * Get insureds value
     * @return \StructType\InsuredPersonCalculatePremiumParms[]|null
     */
    public function getInsureds()
    {
        return $this->insureds;
    }
    /**
     * This method is responsible for validating the values passed to the setInsureds method
     * This method is willingly generated in order to preserve the one-line inline validation within the setInsureds method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateInsuredsForArrayConstraintsFromSetInsureds(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $policyCalculatePremiumParmsInsuredsItem) {
            // validation for constraint: itemType
            if (!$policyCalculatePremiumParmsInsuredsItem instanceof \StructType\InsuredPersonCalculatePremiumParms) {
                $invalidValues[] = is_object($policyCalculatePremiumParmsInsuredsItem) ? get_class($policyCalculatePremiumParmsInsuredsItem) : sprintf('%s(%s)', gettype($policyCalculatePremiumParmsInsuredsItem), var_export($policyCalculatePremiumParmsInsuredsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The insureds property can only contain items of type \StructType\InsuredPersonCalculatePremiumParms, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set insureds value
     * @throws \InvalidArgumentException
     * @param \StructType\InsuredPersonCalculatePremiumParms[] $insureds
     * @return \StructType\PolicyCalculatePremiumParms
     */
    public function setInsureds(array $insureds = array())
    {
        // validation for constraint: array
        if ('' !== ($insuredsArrayErrorMessage = self::validateInsuredsForArrayConstraintsFromSetInsureds($insureds))) {
            throw new \InvalidArgumentException($insuredsArrayErrorMessage, __LINE__);
        }
        $this->insureds = $insureds;
        return $this;
    }
    /**
     * Add item to insureds value
     * @throws \InvalidArgumentException
     * @param \StructType\InsuredPersonCalculatePremiumParms $item
     * @return \StructType\PolicyCalculatePremiumParms
     */
    public function addToInsureds(\StructType\InsuredPersonCalculatePremiumParms $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\InsuredPersonCalculatePremiumParms) {
            throw new \InvalidArgumentException(sprintf('The insureds property can only contain items of type \StructType\InsuredPersonCalculatePremiumParms, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->insureds[] = $item;
        return $this;
    }
    /**
     * Get issuedOn value
     * @return string|null
     */
    public function getIssuedOn()
    {
        return $this->issuedOn;
    }
    /**
     * Set issuedOn value
     * @param string $issuedOn
     * @return \StructType\PolicyCalculatePremiumParms
     */
    public function setIssuedOn($issuedOn = null)
    {
        // validation for constraint: string
        if (!is_null($issuedOn) && !is_string($issuedOn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($issuedOn, true), gettype($issuedOn)), __LINE__);
        }
        $this->issuedOn = $issuedOn;
        return $this;
    }
    /**
     * Get lastDay value
     * @return string|null
     */
    public function getLastDay()
    {
        return $this->lastDay;
    }
    /**
     * Set lastDay value
     * @param string $lastDay
     * @return \StructType\PolicyCalculatePremiumParms
     */
    public function setLastDay($lastDay = null)
    {
        // validation for constraint: string
        if (!is_null($lastDay) && !is_string($lastDay)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastDay, true), gettype($lastDay)), __LINE__);
        }
        $this->lastDay = $lastDay;
        return $this;
    }
    /**
     * Get productCode value
     * @return string|null
     */
    public function getProductCode()
    {
        return $this->productCode;
    }
    /**
     * Set productCode value
     * @param string $productCode
     * @return \StructType\PolicyCalculatePremiumParms
     */
    public function setProductCode($productCode = null)
    {
        // validation for constraint: string
        if (!is_null($productCode) && !is_string($productCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($productCode, true), gettype($productCode)), __LINE__);
        }
        $this->productCode = $productCode;
        return $this;
    }
    /**
     * Get regionCode value
     * @return string|null
     */
    public function getRegionCode()
    {
        return $this->regionCode;
    }
    /**
     * Set regionCode value
     * @param string $regionCode
     * @return \StructType\PolicyCalculatePremiumParms
     */
    public function setRegionCode($regionCode = null)
    {
        // validation for constraint: string
        if (!is_null($regionCode) && !is_string($regionCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($regionCode, true), gettype($regionCode)), __LINE__);
        }
        $this->regionCode = $regionCode;
        return $this;
    }
    /**
     * Get startDay value
     * @return string|null
     */
    public function getStartDay()
    {
        return $this->startDay;
    }
    /**
     * Set startDay value
     * @param string $startDay
     * @return \StructType\PolicyCalculatePremiumParms
     */
    public function setStartDay($startDay = null)
    {
        // validation for constraint: string
        if (!is_null($startDay) && !is_string($startDay)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($startDay, true), gettype($startDay)), __LINE__);
        }
        $this->startDay = $startDay;
        return $this;
    }
    /**
     * Get totalDays value
     * @return int|null
     */
    public function getTotalDays()
    {
        return $this->totalDays;
    }
    /**
     * Set totalDays value
     * @param int $totalDays
     * @return \StructType\PolicyCalculatePremiumParms
     */
    public function setTotalDays($totalDays = null)
    {
        // validation for constraint: int
        if (!is_null($totalDays) && !(is_int($totalDays) || ctype_digit($totalDays))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($totalDays, true), gettype($totalDays)), __LINE__);
        }
        $this->totalDays = $totalDays;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PolicyCalculatePremiumParms
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
