<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InsuredPersonCalculatePremiumParms StructType
 * @subpackage Structs
 */
class InsuredPersonCalculatePremiumParms extends AbstractStructBase
{
    /**
     * The birthDate
     * @var string
     */
    public $birthDate;
    /**
     * The cancellationAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $cancellationAmount;
    /**
     * The currency
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $currency;
    /**
     * The supplementaries
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Supplementaries
     */
    public $supplementaries;
    /**
     * The tariff
     * @var string
     */
    public $tariff;
    /**
     * Constructor method for InsuredPersonCalculatePremiumParms
     * @uses InsuredPersonCalculatePremiumParms::setBirthDate()
     * @uses InsuredPersonCalculatePremiumParms::setCancellationAmount()
     * @uses InsuredPersonCalculatePremiumParms::setCurrency()
     * @uses InsuredPersonCalculatePremiumParms::setSupplementaries()
     * @uses InsuredPersonCalculatePremiumParms::setTariff()
     * @param string $birthDate
     * @param float $cancellationAmount
     * @param string $currency
     * @param \StructType\Supplementaries $supplementaries
     * @param string $tariff
     */
    public function __construct($birthDate = null, $cancellationAmount = null, $currency = null, \StructType\Supplementaries $supplementaries = null, $tariff = null)
    {
        $this
            ->setBirthDate($birthDate)
            ->setCancellationAmount($cancellationAmount)
            ->setCurrency($currency)
            ->setSupplementaries($supplementaries)
            ->setTariff($tariff);
    }
    /**
     * Get birthDate value
     * @return string|null
     */
    public function getBirthDate()
    {
        return $this->birthDate;
    }
    /**
     * Set birthDate value
     * @param string $birthDate
     * @return \StructType\InsuredPersonCalculatePremiumParms
     */
    public function setBirthDate($birthDate = null)
    {
        // validation for constraint: string
        if (!is_null($birthDate) && !is_string($birthDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($birthDate, true), gettype($birthDate)), __LINE__);
        }
        $this->birthDate = $birthDate;
        return $this;
    }
    /**
     * Get cancellationAmount value
     * @return float|null
     */
    public function getCancellationAmount()
    {
        return $this->cancellationAmount;
    }
    /**
     * Set cancellationAmount value
     * @param float $cancellationAmount
     * @return \StructType\InsuredPersonCalculatePremiumParms
     */
    public function setCancellationAmount($cancellationAmount = null)
    {
        // validation for constraint: float
        if (!is_null($cancellationAmount) && !(is_float($cancellationAmount) || is_numeric($cancellationAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($cancellationAmount, true), gettype($cancellationAmount)), __LINE__);
        }
        $this->cancellationAmount = $cancellationAmount;
        return $this;
    }
    /**
     * Get currency value
     * @return string|null
     */
    public function getCurrency()
    {
        return $this->currency;
    }
    /**
     * Set currency value
     * @param string $currency
     * @return \StructType\InsuredPersonCalculatePremiumParms
     */
    public function setCurrency($currency = null)
    {
        // validation for constraint: string
        if (!is_null($currency) && !is_string($currency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currency, true), gettype($currency)), __LINE__);
        }
        $this->currency = $currency;
        return $this;
    }
    /**
     * Get supplementaries value
     * @return \StructType\Supplementaries|null
     */
    public function getSupplementaries()
    {
        return $this->supplementaries;
    }
    /**
     * Set supplementaries value
     * @param \StructType\Supplementaries $supplementaries
     * @return \StructType\InsuredPersonCalculatePremiumParms
     */
    public function setSupplementaries(\StructType\Supplementaries $supplementaries = null)
    {
        $this->supplementaries = $supplementaries;
        return $this;
    }
    /**
     * Get tariff value
     * @return string|null
     */
    public function getTariff()
    {
        return $this->tariff;
    }
    /**
     * Set tariff value
     * @param string $tariff
     * @return \StructType\InsuredPersonCalculatePremiumParms
     */
    public function setTariff($tariff = null)
    {
        // validation for constraint: string
        if (!is_null($tariff) && !is_string($tariff)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tariff, true), gettype($tariff)), __LINE__);
        }
        $this->tariff = $tariff;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\InsuredPersonCalculatePremiumParms
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
