<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for getPolicyList StructType
 * Meta information extracted from the WSDL
 * - type: tns:getPolicyList
 * @subpackage Structs
 */
class GetPolicyList extends AbstractStructBase
{
    /**
     * The uniqueId
     * @var string
     */
    public $uniqueId;
    /**
     * The policyListParms
     * @var \StructType\PolicyListParms
     */
    public $policyListParms;
    /**
     * The language
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $language;
    /**
     * Constructor method for getPolicyList
     * @uses GetPolicyList::setUniqueId()
     * @uses GetPolicyList::setPolicyListParms()
     * @uses GetPolicyList::setLanguage()
     * @param string $uniqueId
     * @param \StructType\PolicyListParms $policyListParms
     * @param string $language
     */
    public function __construct($uniqueId = null, \StructType\PolicyListParms $policyListParms = null, $language = null)
    {
        $this
            ->setUniqueId($uniqueId)
            ->setPolicyListParms($policyListParms)
            ->setLanguage($language);
    }
    /**
     * Get uniqueId value
     * @return string|null
     */
    public function getUniqueId()
    {
        return $this->uniqueId;
    }
    /**
     * Set uniqueId value
     * @param string $uniqueId
     * @return \StructType\GetPolicyList
     */
    public function setUniqueId($uniqueId = null)
    {
        // validation for constraint: string
        if (!is_null($uniqueId) && !is_string($uniqueId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uniqueId, true), gettype($uniqueId)), __LINE__);
        }
        $this->uniqueId = $uniqueId;
        return $this;
    }
    /**
     * Get policyListParms value
     * @return \StructType\PolicyListParms|null
     */
    public function getPolicyListParms()
    {
        return $this->policyListParms;
    }
    /**
     * Set policyListParms value
     * @param \StructType\PolicyListParms $policyListParms
     * @return \StructType\GetPolicyList
     */
    public function setPolicyListParms(\StructType\PolicyListParms $policyListParms = null)
    {
        $this->policyListParms = $policyListParms;
        return $this;
    }
    /**
     * Get language value
     * @return string|null
     */
    public function getLanguage()
    {
        return $this->language;
    }
    /**
     * Set language value
     * @param string $language
     * @return \StructType\GetPolicyList
     */
    public function setLanguage($language = null)
    {
        // validation for constraint: string
        if (!is_null($language) && !is_string($language)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($language, true), gettype($language)), __LINE__);
        }
        $this->language = $language;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetPolicyList
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
