<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DocumentData StructType
 * @subpackage Structs
 */
class DocumentData extends AbstractStructBase
{
    /**
     * The fileName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $fileName;
    /**
     * The fileSize
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $fileSize;
    /**
     * The mimeType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $mimeType;
    /**
     * The fileContents
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $fileContents;
    /**
     * Constructor method for DocumentData
     * @uses DocumentData::setFileName()
     * @uses DocumentData::setFileSize()
     * @uses DocumentData::setMimeType()
     * @uses DocumentData::setFileContents()
     * @param string $fileName
     * @param int $fileSize
     * @param string $mimeType
     * @param string $fileContents
     */
    public function __construct($fileName = null, $fileSize = null, $mimeType = null, $fileContents = null)
    {
        $this
            ->setFileName($fileName)
            ->setFileSize($fileSize)
            ->setMimeType($mimeType)
            ->setFileContents($fileContents);
    }
    /**
     * Get fileName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFileName()
    {
        return isset($this->fileName) ? $this->fileName : null;
    }
    /**
     * Set fileName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fileName
     * @return \StructType\DocumentData
     */
    public function setFileName($fileName = null)
    {
        // validation for constraint: string
        if (!is_null($fileName) && !is_string($fileName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fileName, true), gettype($fileName)), __LINE__);
        }
        if (is_null($fileName) || (is_array($fileName) && empty($fileName))) {
            unset($this->fileName);
        } else {
            $this->fileName = $fileName;
        }
        return $this;
    }
    /**
     * Get fileSize value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getFileSize()
    {
        return isset($this->fileSize) ? $this->fileSize : null;
    }
    /**
     * Set fileSize value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $fileSize
     * @return \StructType\DocumentData
     */
    public function setFileSize($fileSize = null)
    {
        // validation for constraint: int
        if (!is_null($fileSize) && !(is_int($fileSize) || ctype_digit($fileSize))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($fileSize, true), gettype($fileSize)), __LINE__);
        }
        if (is_null($fileSize) || (is_array($fileSize) && empty($fileSize))) {
            unset($this->fileSize);
        } else {
            $this->fileSize = $fileSize;
        }
        return $this;
    }
    /**
     * Get mimeType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMimeType()
    {
        return isset($this->mimeType) ? $this->mimeType : null;
    }
    /**
     * Set mimeType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mimeType
     * @return \StructType\DocumentData
     */
    public function setMimeType($mimeType = null)
    {
        // validation for constraint: string
        if (!is_null($mimeType) && !is_string($mimeType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mimeType, true), gettype($mimeType)), __LINE__);
        }
        if (is_null($mimeType) || (is_array($mimeType) && empty($mimeType))) {
            unset($this->mimeType);
        } else {
            $this->mimeType = $mimeType;
        }
        return $this;
    }
    /**
     * Get fileContents value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFileContents()
    {
        return isset($this->fileContents) ? $this->fileContents : null;
    }
    /**
     * Set fileContents value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fileContents
     * @return \StructType\DocumentData
     */
    public function setFileContents($fileContents = null)
    {
        // validation for constraint: string
        if (!is_null($fileContents) && !is_string($fileContents)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fileContents, true), gettype($fileContents)), __LINE__);
        }
        if (is_null($fileContents) || (is_array($fileContents) && empty($fileContents))) {
            unset($this->fileContents);
        } else {
            $this->fileContents = $fileContents;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DocumentData
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
